const plugin = require("tailwindcss/plugin")
const colors = require('tailwindcss/colors')

module.exports = {
    mode: 'jit',
    purge: {
        enabled: false,
        content: [
            './vendor/wire-elements/modal/resources/views/*.blade.php',
            // './storage/framework/views/*.php',
            './app/**/*.php',
            // './app/Http/Livewire/*Modal.php',
            // './app/Http/Livewire/*ModalComponent.php',
            './resources/views/**/*.blade.php',
            './safelist.txt',
            "./node_modules/flowbite/**/*.js",
        ],
        options: {
            safelist: [
                'sm:max-w-2xl',
                'sm:max-w-sm',
                'sm:max-w-md',
                'md:max-w-lg',
                'md:max-w-xl',
                'lg:max-w-2xl',
                'lg:max-w-3xl',
                'xl:max-w-4xl',
                'xl:max-w-5xl',
                '2xl:max-w-6xl',
                '2xl:max-w-7xl',
            ]
        }
    },
    theme: {
        extend: {
            colors: {
                indigo: colors.indigo,
                // rose: colors.rose,
                "rose": {
                    "50": "#E4F5FC",
                    "100": "#CDECF9",
                    "200": "#9AD9F4",
                    "300": "#68C6EE",
                    "400": "#35B3E8",
                    "500": "#1796CC",
                    "600": "#1379A5",
                    "700": "#0E5B7C",
                    "800": "#093D52",
                    "900": "#051E29"
                },
                blueGray: colors.blueGray,
                lightBlue: colors.sky,
                orange: colors.orange,
                red: colors.red
            },
            minHeight: {
                'screen-75': '75vh'
            },
            fontSize: {
                '55': '55rem',
                '2xs': ['0.5rem', {
                    // lineHeight: '2rem',
                    // letterSpacing: '-0.01em',
                    // fontWeight: '500',
                }],
                '3xs': ['0.33rem', {
                    // lineHeight: '2.25rem',
                    // letterSpacing: '-0.02em',
                    // fontWeight: '700',
                }],
            },
            opacity: {
                '80': '.8'
            },
            zIndex: {
                '2': 2,
                '3': 3
            },
            inset: {
                '-100': '-100%',
                '-225-px': '-225px',
                '-160-px': '-160px',
                '-150-px': '-150px',
                '-94-px': '-94px',
                '-50-px': '-50px',
                '-29-px': '-29px',
                '-20-px': '-20px',
                '25-px': '25px',
                '40-px': '40px',
                '95-px': '95px',
                '145-px': '145px',
                '195-px': '195px',
                '210-px': '210px',
                '260-px': '260px'
            },
            height: {
                '95-px': '95px',
                '70-px': '70px',
                '350-px': '350px',
                '500-px': '500px',
                '600-px': '600px'
            },
            maxHeight: {
                '860-px': '860px'
            },
            maxWidth: {
                '100-px': '100px',
                '120-px': '120px',
                '150-px': '150px',
                '180-px': '180px',
                '200-px': '200px',
                '210-px': '210px',
                '580-px': '580px'
            },
            minWidth: {
                '140-px': '140px',
                '48': '12rem'
            },
            backgroundSize: {
                full: '100$'
            }
        }
    },
    variants: [
        'responsive',
        'group-hover',
        'focus-within',
        'first',
        'last',
        'odd',
        'even',
        'hover',
        'focus',
        'active',
        'visited',
        'disabled'
    ],
    plugins: [
        require('@tailwindcss/forms'),
        plugin(function ({ addComponents, theme }) {
            const screens = theme("screens", {});
            addComponents([
                {
                    ".container": { width: "100%" },
                },
                {
                    [`@media (min-width: ${screens.sm})`]: {
                        ".container": {
                            "max-width": "640px",
                        },
                    },
                },
                {
                    [`@media (min-width: ${screens.md})`]: {
                        ".container": {
                            "max-width": "768px",
                        },
                    },
                },
                {
                    [`@media (min-width: ${screens.lg})`]: {
                        ".container": {
                            "max-width": "1024px",
                        },
                    },
                },
                {
                    [`@media (min-width: ${screens.xl})`]: {
                        ".container": {
                            "max-width": "1280px",
                        },
                    },
                },
                {
                    [`@media (min-width: ${screens["2xl"]})`]: {
                        ".container": {
                            "max-width": "1280px",
                        },
                    },
                },
            ]);
        }),
        require('flowbite/plugin'),
    ]
}
