<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('Vb1HQJl')) {
    $componentId = $_instance->getRenderedChildComponentId('Vb1HQJl');
    $componentTag = $_instance->getRenderedChildComponentTagName('Vb1HQJl');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Vb1HQJl');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('Vb1HQJl', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('lWSCTMS')) {
    $componentId = $_instance->getRenderedChildComponentId('lWSCTMS');
    $componentTag = $_instance->getRenderedChildComponentTagName('lWSCTMS');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('lWSCTMS');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('lWSCTMS', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('eKxYLjJ')) {
    $componentId = $_instance->getRenderedChildComponentId('eKxYLjJ');
    $componentTag = $_instance->getRenderedChildComponentTagName('eKxYLjJ');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('eKxYLjJ');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttribute','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('eKxYLjJ', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.lgAttribute.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttribute.fields.title')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttribute.fields.description')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttribute.fields.is_active')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'is_active'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttribute.fields.type')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttribute.fields.ledger_group')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'ledger_group.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $lgAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lgAttribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($lgAttribute->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($lgAttribute->id); ?>

                            </td>
                            <td>
                                <?php echo e($lgAttribute->title); ?>

                            </td>
                            <td>
                                <?php echo e($lgAttribute->description); ?>

                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled <?php echo e($lgAttribute->is_active ? 'checked' : ''); ?>>
                            </td>
                            <td>
                                <?php echo e($lgAttribute->type_label); ?>

                            </td>
                            <td>
                                <?php if($lgAttribute->ledgerGroup): ?>
                                    <span class="badge badge-relationship"><?php echo e($lgAttribute->ledgerGroup->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.lg-attributes.show', $lgAttribute)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.lg-attributes.edit', $lgAttribute)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($lgAttribute->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($lgAttributes->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/lg-attribute/index.blade.php ENDPATH**/ ?>