<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.zone.title_singular')); ?>:
                    <?php echo e(trans('cruds.zone.fields.id')); ?>

                    <?php echo e($zone->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.zone.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($zone->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.zone.fields.name')); ?>

                            </th>
                            <td>
                                <?php echo e($zone->name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.zone.fields.is_active')); ?>

                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled <?php echo e($zone->is_active ? 'checked' : ''); ?>>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.zone.fields.state')); ?>

                            </th>
                            <td>
                                <?php if($zone->state): ?>
                                    <span class="badge badge-relationship"><?php echo e($zone->state->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('zone_edit')): ?>
                    <a href="<?php echo e(route('admin.zones.edit', $zone)); ?>" class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.zones.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/zone/show.blade.php ENDPATH**/ ?>