<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_document_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('qBtRoUK')) {
    $componentId = $_instance->getRenderedChildComponentId('qBtRoUK');
    $componentTag = $_instance->getRenderedChildComponentTagName('qBtRoUK');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('qBtRoUK');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('qBtRoUK', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('mi2GoX1')) {
    $componentId = $_instance->getRenderedChildComponentId('mi2GoX1');
    $componentTag = $_instance->getRenderedChildComponentTagName('mi2GoX1');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('mi2GoX1');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('mi2GoX1', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('A8w6KHY')) {
    $componentId = $_instance->getRenderedChildComponentId('A8w6KHY');
    $componentTag = $_instance->getRenderedChildComponentTagName('A8w6KHY');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('A8w6KHY');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmDocument','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('A8w6KHY', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.crmDocument.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmDocument.fields.customer')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'customer.first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmDocument.fields.document_file')); ?>

                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmDocument.fields.name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $crmDocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crmDocument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($crmDocument->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($crmDocument->id); ?>

                            </td>
                            <td>
                                <?php if($crmDocument->customer): ?>
                                    <span class="badge badge-relationship"><?php echo e($crmDocument->customer->first_name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php $__currentLoopData = $crmDocument->document_file; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="link-light-blue" href="<?php echo e($entry['url']); ?>">
                                        <i class="far fa-file">
                                        </i>
                                        <?php echo e($entry['file_name']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php echo e($crmDocument->name); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_document_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.crm-documents.show', $crmDocument)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_document_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.crm-documents.edit', $crmDocument)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_document_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($crmDocument->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($crmDocuments->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/crm-document/index.blade.php ENDPATH**/ ?>