<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_transaction_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('QOdU0RN')) {
    $componentId = $_instance->getRenderedChildComponentId('QOdU0RN');
    $componentTag = $_instance->getRenderedChildComponentTagName('QOdU0RN');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('QOdU0RN');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('QOdU0RN', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('ickhlv6')) {
    $componentId = $_instance->getRenderedChildComponentId('ickhlv6');
    $componentTag = $_instance->getRenderedChildComponentTagName('ickhlv6');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('ickhlv6');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('ickhlv6', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('RlyIj0e')) {
    $componentId = $_instance->getRenderedChildComponentId('RlyIj0e');
    $componentTag = $_instance->getRenderedChildComponentTagName('RlyIj0e');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('RlyIj0e');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerTransaction','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('RlyIj0e', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.ledgerTransaction.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.fin_yr')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'fin_yr.title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.finYr.fields.alias')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'fin_yr.alias'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.ledger')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'ledger.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.date')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.amount')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.type')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.cr_bal_before')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'cr_bal_before'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.dr_bal_before')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'dr_bal_before'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.cr_bal_after')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'cr_bal_after'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.dr_bal_after')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'dr_bal_after'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerTransaction.fields.description')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ledgerTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledgerTransaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($ledgerTransaction->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->id); ?>

                            </td>
                            <td>
                                <?php if($ledgerTransaction->finYr): ?>
                                    <span class="badge badge-relationship"><?php echo e($ledgerTransaction->finYr->title ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($ledgerTransaction->finYr): ?>
                                    <?php echo e($ledgerTransaction->finYr->alias ?? ''); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($ledgerTransaction->ledger): ?>
                                    <span class="badge badge-relationship"><?php echo e($ledgerTransaction->ledger->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->date); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->amount); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->type_label); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->cr_bal_before); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->dr_bal_before); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->cr_bal_after); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->dr_bal_after); ?>

                            </td>
                            <td>
                                <?php echo e($ledgerTransaction->description); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_transaction_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.ledger-transactions.show', $ledgerTransaction)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_transaction_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.ledger-transactions.edit', $ledgerTransaction)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_transaction_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($ledgerTransaction->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($ledgerTransactions->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/ledger-transaction/index.blade.php ENDPATH**/ ?>