<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('circle_product_pivot_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('7T4S4uL')) {
    $componentId = $_instance->getRenderedChildComponentId('7T4S4uL');
    $componentTag = $_instance->getRenderedChildComponentTagName('7T4S4uL');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('7T4S4uL');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('7T4S4uL', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('sTP7QLu')) {
    $componentId = $_instance->getRenderedChildComponentId('sTP7QLu');
    $componentTag = $_instance->getRenderedChildComponentTagName('sTP7QLu');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('sTP7QLu');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('sTP7QLu', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('P6fTvgx')) {
    $componentId = $_instance->getRenderedChildComponentId('P6fTvgx');
    $componentTag = $_instance->getRenderedChildComponentTagName('P6fTvgx');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('P6fTvgx');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('P6fTvgx', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        
                        <th class="w-28">
                            ID
                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            Invoice No
                            <?php echo $__env->make('components.table.sort', ['field' => 'invoice_no'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            Invoice Date
                            <?php echo $__env->make('components.table.sort', ['field' => 'date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            Due Date
                            <?php echo $__env->make('components.table.sort', ['field' => 'due_date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            Client
                            <?php echo $__env->make('components.table.sort', ['field' => 'client.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            Total
                            <?php echo $__env->make('components.table.sort', ['field' => 'total'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        
                        <tr>
                            
                            <td>
                                <?php echo e($invoice->id); ?>

                            </td>
                            <td>
                                <?php echo e($invoice->invoice_no); ?>

                            </td>
                            <td>
                                <?php echo e($invoice->date_f); ?>

                            </td>
                            <td>
                                <?php echo e($invoice->due_date_f); ?>

                            </td>
                            <td>
                                <?php if($invoice->client): ?>
                                    <span class="badge badge-relationship"><?php echo e($invoice->client->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            
                            <td>
                                <?php echo e(number_format_money($invoice->total)); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <a class="btn btn-sm btn-info mr-2"
                                        href="<?php echo e(route('admin.invoices.show', $invoice)); ?>">
                                        <?php echo e(trans('global.view')); ?>

                                    </a>
                                    <a class="btn btn-sm btn-success mr-2"
                                        href="<?php echo e(route('admin.invoices.edit', $invoice)); ?>">
                                        <?php echo e(trans('global.edit')); ?>

                                    </a>
                                    <button class="btn btn-sm btn-rose mr-2" type="button"
                                        wire:click="confirm('delete', <?php echo e($invoice->id); ?>)"
                                        wire:loading.attr="disabled">
                                        <?php echo e(trans('global.delete')); ?>

                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($invoices->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
                return
            }
            window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/admin/invoices/index.blade.php ENDPATH**/ ?>