<div wire:submit.prevent="submit" class="pt-3">
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php if($zone): ?>
        <div class="relative">

            <div class="overflow-x-auto mb-3">
                <table class="table table-index w-full">
                    <thead>
                        <tr>
                            <th>Product Name/Description</th>
                            
                            <th>Type</th>
                            <th>Current Stock</th>
                            <th>Requested Quantity</th>
                            
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $productRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $stockAvailable = $cStock($p->product_id);
                                $canAccept = $stockAvailable >= $p->requested_quantity;
                                $needAccept = $stockAvailable >= $p->quantity;
                                $needQuantity = $p->requested_quantity - $stockAvailable;

                            ?>
                            <tr class="" id="<?php echo e(uniqid()); ?>">
                                <td>
                                    <code>#<?php echo e($p->id); ?></code>
                                    <span> <?php echo e($p->p_name); ?> </span>
                                    <span class="text-2xs block"> <?php echo e($p->p_description); ?> </span>
                                </td>
                                
                                <td>
                                    <?php echo e($p->p_listed ? 'Listed' : 'Unlisted'); ?>

                                </td>
                                <td>
                                    <?php echo e($stockAvailable); ?>

                                </td>
                                <td>
                                    <?php echo e($p->requested_quantity); ?>

                                </td>

                                <td>

                                    <?php if($canAccept): ?>
                                        <?php if($p->status == 'accepted'): ?>
                                            <span class="text-sm">Product Sent</span>
                                        <?php else: ?>
                                            <button type="button" class="btn btn-primary btn-sm"
                                                wire:click="acceptProductRequest('<?php echo e($p->product_id); ?>','<?php echo e($p->id); ?>')">Accept
                                                And Send</button>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        
                                        
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($productRequests->count() == 0): ?>
                            <tr>
                                <td class="text-center py-2" colspan="4">
                                    No products found
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
        </div>
    <?php endif; ?>

    
    
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        $.ready(function() {
            $(document).on('input', "#simpleSearchInput", function() {
                var value = $(this).val().toLowerCase();
                console.log("value", value)
                $("#simpleSearchTable tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            })
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/zonal-officer/zone/product/zo-product-requests-component.blade.php ENDPATH**/ ?>