<div>

    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.task.title_singular')); ?>:
                    <?php echo e(trans('cruds.task.fields.id')); ?>

                    <?php echo e($task->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view ">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($task->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.name')); ?>

                            </th>
                            <td>
                                <?php echo e($task->name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.description')); ?>

                            </th>
                            <td>
                                <?php echo e($task->description); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.status')); ?>

                            </th>
                            <td>
                                <?php if($task->status): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->status->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.tag')); ?>

                            </th>
                            <td>
                                <?php $__currentLoopData = $task->tag; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-relationship"><?php echo e($entry->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.attachment')); ?>

                            </th>
                            <td>
                                <?php $__currentLoopData = $task->attachment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="link-light-blue" href="<?php echo e($entry['url']); ?>">
                                        <i class="far fa-file">
                                        </i>
                                        <?php echo e($entry['file_name']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.due_date')); ?>

                            </th>
                            <td>
                                <?php echo e($task->due_date); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.assigned_to')); ?>

                            </th>
                            <td>
                                <?php if($task->assignedTo): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->assignedTo->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.client_group')); ?>

                            </th>
                            <td>
                                <?php if($task->clientGroup): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->clientGroup->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.client')); ?>

                            </th>
                            <td>
                                <?php if($task->client): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->client->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.client_branch')); ?>

                            </th>
                            <td>
                                <?php if($task->clientBranch): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->clientBranch->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                Circle
                            </th>
                            <td>
                                <?php if($task->circle): ?>
                                    <span class="badge badge-relationship"><?php echo e($task->circle->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.call_type')); ?>

                            </th>
                            <td>
                                <?php echo e($task->call_type_label); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.task.fields.incode')); ?>

                            </th>
                            <td>
                                <?php echo e($task->incode); ?>

                            </td>
                        </tr>
                        <?php if($task->isTaskClosed() && $task->taskClosedLogLatest && $task->taskClosedLogLatest->call_report_image_url): ?>
                            <tr>
                                <th>
                                    Call Report
                                </th>
                                <td>

                                    <img src="<?php echo e($task->taskClosedLogLatest->call_report_image_url); ?>"
                                        alt="Call Report" class="square object-fit h-10 w-10">
                                    <button class="btn btn-primary mt-2 "
                                        onclick="viewLink('<?php echo e($task->taskClosedLogLatest->call_report_image_url); ?>')">View</button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <a wire:click="$emit('openModal', 'task.task-assign-engineer-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                    class="btn btn-indigo mr-2">
                    Assign Engineer
                </a>
                <?php if($can_assign_engineer): ?>
                <?php endif; ?>
                <?php if($can_change_status): ?>
                    <a wire:click="$emit('openModal', 'task.task-change-status-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                        class="btn btn-indigo mr-2">
                        Change Status
                    </a>
                <?php endif; ?>
                <?php if($can_change_status): ?>
                    <a wire:click="$emit('openModal', 'task.co-task-products-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                        class="btn btn-indigo mr-2">
                        Products Requested
                    </a>
                <?php endif; ?>
                <a wire:click="$emit('openModal', 'task.task-timeline-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                    class="btn btn-indigo mr-2">
                    Timeline
                </a>
                <a href="<?php echo e(route('co.tasks.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>

            <div id="accordion-collapse" data-accordion="collapse" class="hidden">
                <h2 id="accordion-collapse-heading-1">
                    <button type="button"
                        class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                        data-accordion-target="#accordion-collapse-body-1" aria-expanded="true"
                        aria-controls="accordion-collapse-body-1">
                        <span>What is Flowbite?</span>
                        <svg data-accordion-icon class="w-6 h-6 rotate-180 shrink-0" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </h2>
                <div id="accordion-collapse-body-1" class="hidden" aria-labelledby="accordion-collapse-heading-1">
                    <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                        <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is an open-source library of
                            interactive components built on top of Tailwind CSS including buttons, dropdowns, modals,
                            navbars, and more.</p>
                        <p class="text-gray-500 dark:text-gray-400">Check out this guide to learn how to <a
                                href="/docs/getting-started/introduction/"
                                class="text-blue-600 dark:text-blue-500 hover:underline">get started</a> and start
                            developing websites even faster with components on top of Tailwind CSS.</p>
                    </div>
                </div>
                <h2 id="accordion-collapse-heading-2">
                    <button type="button"
                        class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                        data-accordion-target="#accordion-collapse-body-2" aria-expanded="false"
                        aria-controls="accordion-collapse-body-2">
                        <span>Is there a Figma file available?</span>
                        <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </h2>
                <div id="accordion-collapse-body-2" class="hidden" aria-labelledby="accordion-collapse-heading-2">
                    <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700">
                        <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is first conceptualized and designed
                            using the Figma software so everything you see in the library has a design equivalent in our
                            Figma file.</p>
                        <p class="text-gray-500 dark:text-gray-400">Check out the <a href="https://flowbite.com/figma/"
                                class="text-blue-600 dark:text-blue-500 hover:underline">Figma design system</a> based
                            on the utility classes from Tailwind CSS and components from Flowbite.</p>
                    </div>
                </div>
                <h2 id="accordion-collapse-heading-3">
                    <button type="button"
                        class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                        data-accordion-target="#accordion-collapse-body-3" aria-expanded="false"
                        aria-controls="accordion-collapse-body-3">
                        <span>What are the differences between Flowbite and Tailwind UI?</span>
                        <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </h2>
                <div id="accordion-collapse-body-3" class="hidden" aria-labelledby="accordion-collapse-heading-3">
                    <div class="p-5 font-light border border-t-0 border-gray-200 dark:border-gray-700">
                        <p class="mb-2 text-gray-500 dark:text-gray-400">The main difference is that the core components
                            from Flowbite are open source under the MIT license, whereas Tailwind UI is a paid product.
                            Another difference is that Flowbite relies on smaller and standalone components, whereas
                            Tailwind UI offers sections of pages.</p>
                        <p class="mb-2 text-gray-500 dark:text-gray-400">However, we actually recommend using both
                            Flowbite, Flowbite Pro, and even Tailwind UI as there is no technical reason stopping you
                            from using the best of two worlds.</p>
                        <p class="mb-2 text-gray-500 dark:text-gray-400">Learn more about these technologies:</p>
                        <ul class="pl-5 text-gray-500 list-disc dark:text-gray-400">
                            <li><a href="https://flowbite.com/pro/"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">Flowbite Pro</a></li>
                            <li><a href="https://tailwindui.com/" rel="nofollow"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">Tailwind UI</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/circle-officer/task/task-show-co.blade.php ENDPATH**/ ?>