<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_task_event_log_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('1SXYZii')) {
    $componentId = $_instance->getRenderedChildComponentId('1SXYZii');
    $componentTag = $_instance->getRenderedChildComponentTagName('1SXYZii');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('1SXYZii');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('1SXYZii', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('3vutbE5')) {
    $componentId = $_instance->getRenderedChildComponentId('3vutbE5');
    $componentTag = $_instance->getRenderedChildComponentTagName('3vutbE5');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('3vutbE5');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('3vutbE5', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('qkhqiOF')) {
    $componentId = $_instance->getRenderedChildComponentId('qkhqiOF');
    $componentTag = $_instance->getRenderedChildComponentTagName('qkhqiOF');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('qkhqiOF');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ProductTaskEventLog','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('qkhqiOF', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.productTaskEventLog.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.task_event_log')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'task_event_log.event_type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.product')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'product.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.quantity')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'quantity'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.status')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.approved_by')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'approved_by.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.productTaskEventLog.fields.approved_at')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'approved_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $productTaskEventLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productTaskEventLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($productTaskEventLog->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($productTaskEventLog->id); ?>

                            </td>
                            <td>
                                <?php if($productTaskEventLog->taskEventLog): ?>
                                    <span class="badge badge-relationship"><?php echo e($productTaskEventLog->taskEventLog->event_type ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($productTaskEventLog->product): ?>
                                    <span class="badge badge-relationship"><?php echo e($productTaskEventLog->product->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($productTaskEventLog->quantity); ?>

                            </td>
                            <td>
                                <?php echo e($productTaskEventLog->status_label); ?>

                            </td>
                            <td>
                                <?php if($productTaskEventLog->approvedBy): ?>
                                    <span class="badge badge-relationship"><?php echo e($productTaskEventLog->approvedBy->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($productTaskEventLog->approved_at); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_task_event_log_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.product-task-event-logs.show', $productTaskEventLog)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_task_event_log_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.product-task-event-logs.edit', $productTaskEventLog)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_task_event_log_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($productTaskEventLog->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($productTaskEventLogs->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/product-task-event-log/index.blade.php ENDPATH**/ ?>