<div wire:ignore>
    <div class="flatpickr flatpickr-<?php echo e($attributes['id']); ?> relative">
        <?php if(!isset($attributes['required'])): ?>
            <div class="absolute inset-y-0 left-0 flex items-center">
                <button id="clear-<?php echo e($attributes['id']); ?>" type="button" class="text-rose-600 w-10 h-full" data-clear>
                    <i class="far fa-times-circle"></i>
                </button>
            </div>
        <?php endif; ?>

        <input type="text" class="form-control" <?php echo e($attributes); ?> data-input>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener("livewire:load", () => {
    function update(value) {
        let el = document.getElementById('clear-<?php echo e($attributes['id']); ?>')

        if (value === '') {
            value = null

            if (el !== null) {
                el.classList.add('invisible')
            }
        } else if (el !== null) {
            el.classList.remove('invisible')
        }

window.livewire.find('<?php echo e($_instance->id); ?>').set('<?php echo e($attributes['wire:model']); ?>', value)
    }

<?php if($attributes['picker'] === 'date'): ?>
        let el = flatpickr('.flatpickr-<?php echo e($attributes['id']); ?>', {
            dateFormat: "<?php echo e(config('project.flatpickr_date_format')); ?>",
            wrap: true,
            onChange: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            },
            onReady: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            }
        })
<?php elseif($attributes['picker'] === 'time'): ?>
        let el = flatpickr('.flatpickr-<?php echo e($attributes['id']); ?>', {
            enableTime: true,
            // enableSeconds: true,
            noCalendar: true,
            time_24hr: true,
            wrap: true,
            dateFormat: "<?php echo e(config('project.flatpickr_time_format')); ?>",
            onChange: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            },
            onReady: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            }
        })
<?php else: ?>
        let el = flatpickr('.flatpickr-<?php echo e($attributes['id']); ?>', {
            enableTime: true,
            time_24hr: true,
            wrap: true,
            // enableSeconds: true,
            dateFormat: "<?php echo e(config('project.flatpickr_datetime_format')); ?>",
            onChange: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            },
            onReady: (SelectedDates, DateStr, instance) => {
                update(DateStr)
            }
        })
<?php endif; ?>
});
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/components/date-picker.blade.php ENDPATH**/ ?>