<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <title>GST invoice</title>
    <link href="https://fonts.googleapis.com/css2?family=Muli:wght@200;300;400;500;700&display=swap" rel="stylesheet">
    <style type="text/css">
        table:not([border="0"]) th,
        table:not([border="0"]) td {
            border: 1pt solid #000 !important;
            border-collapse: collapse !important;
            padding: 5px;
        }

        html {
            font-family: sans-serif;
            line-height: 1.05;
            margin: 0;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            font-weight: 400;
            line-height: 1.05;
            color: #212529;
            text-align: left;
            background-color: #fff;
            font-size: 10px;
            /* margin: 20pt; */
            margin: 5pt 8pt 5pt 8pt;
            /* margin: 36pt; */
        }

        @media print {
            @page {
                size: A4 landscape;
                margin: 3pt;
            }

        }

        .itemsTable {
            border-collapse: collapse;
            width: 100%;
        }

        .itemsTable td {
            border: 1px solid #000;
            /* padding: 5px; */
        }
    </style>

    <style>
        .visible {
            visibility: visible;
        }

        .collapse {
            visibility: collapse;
        }

        .fixed {
            position: fixed;
        }

        .m-0 {
            margin: 0px;
        }

        .inline-block {
            display: inline-block;
        }

        .table {
            display: table;
        }

        .w-\[50\%\] {
            width: 50%;
        }

        .border-collapse {
            border-collapse: collapse;
        }

        .border {
            border-width: 1px;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .text-2xs {
            font-size: 0.65rem;
        }

        .text-3xs {
            font-size: 0.55rem;
        }

        .p-\[0\.5em\],
        .p-pn {
            padding: 0.5em;
        }
    </style>


    <style>
        .table-bordered td,
        .table-bordered th {
            border: 1pt solid #000 !important;
        }

        .txtbody td,
        .itmstbody td {
            pading: 2bit;
            solid transparent.
        }
    </style>


</head>

<body>

    <table style="border:1px solid #999999;border-collapse:collapse;" width="100%" border="0" cellpadding="0"
        cellspacing="0" class="tb x-table-bordered">
        <tbody>
            <tr>
                <td height="10" colspan="5" align="left" class="txt"
                    style="border-left: 0px solid transparent; color:#000; font-size:1.25em; font-weight:800; font-family: 'Muli', sans-serif; padding: 0.5em;">
                    <h1 style=" text-transform: uppercase;">Tri Infotek Services (LLP)</h1>
                    <p style=" font-size:1.0em;">
                        Sukanta Nagar, P.O. Rabindra Nagar, Chinsurah, Hooghly-712103 <br />
                        EMAIL: helpdesk@triinfotek.com/services@triinfotek.com <br />
                        GSTN: 19AAQFT7886B1ZG

                    </p>
                </td>
                <td align="right" style="border-right: 0px solid transparent; padding: 0.5em;">
                    <span>
                        <img width="77" height="77" alt="image"
                            src="<?php echo e(url('res/images/logo_v1.jpg')); ?>"></span>
                </td>
            </tr>
            <tr>
                <td height="10" colspan="6" align="center" class="txt"
                    style="border:1px solid #000; color:#000; font-size:0.85em; font-weight:800; font-family: 'Muli', sans-serif;">
                    <p style="font-size:1.35em;">TAX INVOICE</p>
                </td>
            </tr>
            <tr>
                <td height="10" colspan="6" align="center" class="txt"
                    style="border:1px solid #000; color:#000; font-size:0.70em; font-weight:800; font-family: 'Muli', sans-serif;">
                    <p style="font-size:1.35em;">"ORIGINAL FOR RECIPIENT/DUPLICATE FOR TRANSPORTER/TRIPLICATE FOR
                        SUPPLIER "</p>
                </td>
            </tr>
        </tbody>
    </table>


    <table style="border:1px solid #000;border-collapse:collapse;" width="100%" border="0" cellpadding="0"
        cellspacing="0" class="tb table-bordered">
        <tbody>
            <tr>
                <td class="p-pn" x-style="width:55%;" colspan="5">
                    <b>Bill To:</b> <?php echo e($_get('client_name')); ?>

                </td>
                <td colspan="1">State Of Supply</td>
                <td colspan="2"><?php echo e($_get('rhq_state')); ?></td>
                
            </tr>
            <tr>
                <td class="p-pn" colspan="5" style="width: 60% !important;">
                    <b>Address:</b> <?php echo e($_get('rhq_address')); ?>

                </td>
                
                <td colspan="1">Invoice No</td>
                <td colspan="2"><?php echo e($invoice->invoice_no); ?></td>
                
            </tr>
            <tr>
                <td class="p-pn" colspan="5">
                    <b>State:</b> <?php echo e($_get('rhq_state')); ?>

                </td>
                <td colspan="1">Financial Year</td>
                <td colspan="2"><?php echo e($_get('inv_fin_year')); ?></td>
                
            </tr>
            <tr>
                <td class="p-pn" colspan="5">
                    <b>Contact No.:</b> <?php echo e($_get('rhq_phone')); ?>

                </td>
                <td colspan="1">Date - </td>
                <td colspan="2" style="border: 1pt solid #000; "><?php echo e($invoice->date?->format('d-m-Y')); ?></td>
                
            </tr>
            <tr>
                <td class="p-pn" colspan="5">
                    <b>GSTIN:</b> <?php echo e($_get('gstin')); ?>

                </td>
                <td colspan="1">Due Date - </td>
                <td colspan="2" style="border: 1pt solid #000; "><?php echo e($invoice->due_date?->format('d-m-Y')); ?></td>
                
            </tr>
            <tr>
                <td class="p-pn" colspan="5">
                </td>
                <td colspan="3"></td>
            </tr>
            <tr style="display:none; ">
                
                <td colspan="4">
                    <table width="100%" border="0">
                        <tr>
                            <td width="30%">
                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td height="20" valign="bottom"
                                                style=" font-size:20px; color:#d04e00; font-weight:800; font-family: 'Muli', sans-serif;">
                                                Tri Infotek Services LLP
                                            </td>
                                        </tr>
                                        <tr>
                                            <td
                                                style=" font-size:9px; color:#000; padding:1px; font-family: 'Muli', sans-serif; text-transform:capitalize">
                                                Office : Sukanta Nagar,P.O-Rabindra Nagar <br />
                                                chinsurah,hooghly,pin-712103

                                            </td>
                                        </tr>
                                        
                                        
                                        <tr>
                                            <td
                                                style=" font-size:9px; color:#000; padding:1px; font-family: 'Muli', sans-serif;">
                                                GSTIN : 19AAQFT7886B1ZG
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td height="20" valign="bottom"
                                                style=" font-size:15px; color:#d04e00; font-weight:800; font-family: 'Muli', sans-serif;">
                                                <span>To,</span><br>
                                                <?php echo e($_get('client_name')); ?>

                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td
                                                style=" font-size:9px; color:#000; padding:1px; font-family: 'Muli', sans-serif;">
                                                Office : <?php echo e($_get('rhq_address')); ?></td>
                                        </tr>
                                        <tr>
                                            <td
                                                style=" font-size:9px; color:#000; padding:1px; font-family: 'Muli', sans-serif;">
                                                Email: <?php echo e($_get('rhq_email')); ?> <br />
                                                Phone: <?php echo e($_get('rhq_phone')); ?></td>
                                        </tr>
                                        <tr>
                                            <td
                                                style=" font-size:9px; color:#000; padding:1px; font-family: 'Muli', sans-serif;">
                                                GSTIN : <?php echo e($_get('gstin')); ?>, </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                            <td width="40%">&nbsp;</td>
                            <td>
                            </td>
                            <td width="30%" style="vertical-align: top;">

                                <table style="border:1pt solid black; border-collapse: collapse;" width="100%"
                                    border="0" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td width="50%" height="12" style="border:1px solid black;">
                                                <strong><span
                                                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">Invoice
                                                        No : </span><?php echo e($invoice->invoice_no); ?></strong>
                                            </td>
                                            <td width="50%" style="border:1px solid black;"><span
                                                    style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">Date:
                                                    <?php echo e($invoice->date_f); ?></span>
                                            </td>

                                        </tr>
                                        <tr>
                                            <td width="50%" height="12" style="border:1px solid black;">
                                                <strong>
                                                    
                                                </strong>
                                            </td>
                                            <td width="50%" style="border:1px solid black;"><span
                                                    style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">
                                                    Due date: <?php echo e($invoice->due_date_f); ?>

                                                </span>
                                            </td>

                                        </tr>
                                    </tbody>
                                </table>
                                <table style="border:0pt solid black; border-collapse: collapse; margin-top:10pt;"
                                    width="100%" border="0" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td width="50%" height="10" style="border:0px solid black;">
                                                <strong>
                                                    <span
                                                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;"></span></strong>
                                            </td>
                                            <td width="50%" style="border:1pt solid black;padding:5px">
                                                <span
                                                    style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">
                                                    Bank Details :-
                                                    <hr />
                                                    BRABOURNE ROAD BRANCH <br />
                                                    KOLKATA<br />
                                                    A/C-0100002100589323<br />
                                                    IFSC CODE: PUNB0010000
                                                </span>
                                            </td>

                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </table>

                </td>
                
            </tr>
            
        </tbody>
    </table>



    <table class="itemsTable" style="border:1pt solid black; border-collapse: collapse; border-right: 1pt solid #000"
        width="100%">
        <thead>
            <tr style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif; ">
                
                <td width="45%" align="center"><strong>Description </strong></td>
                <td width="11%" align="center"><strong>HSN/SAC</strong></td>
                <td width="11%" align="center"><strong>RATE</strong></td>
                
                <td width="11%" align="center"><strong>Taxable Amount</strong></td>
                <td width="11%" align="center"><strong>Qty.</strong></td>
                <td width="11%" align="center"><strong>Amount</strong></td>
            </tr>
        </thead>
        <tbody class="itmstbody">
            <?php for($i = 0; $i < 1; $i++): ?>

                <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">
                        
                        <td>
                            <p class="m-0 "> <?php echo e($item->name); ?></p>
                            
                        </td>
                        <td align="center"> <?php echo e($item->hsn_code); ?></td>
                        
                        <td align="center"> <?php echo e($item->igst_rate); ?></td>
                        <td align="center"> <?php echo e($item->taxable_price); ?></td>
                        <td align="center"> <?php echo e($item->quantity); ?></td>
                        <td align="center"> <?php echo e($item->taxable_price * $item->quantity); ?></td>
                    </tr>
                    <tr>
                        <td>
                            <span class=""><?php echo e($item->description); ?></span>
                        </td>
                        <td align="center"> </td>
                        <td align="center"> </td>
                        <td align="center"> </td>
                        <td align="center"> </td>
                        <td align="center"> </td>
                        
                        
                        

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endfor; ?>
        </tbody>
    
        <tbody class="txtbody">
            <tr>
                <td colspan="6">&nbsp;</td>
            </tr>
            <tr>
                <th align="right">Tax Type</th>
                <th align="center">Taxable <br />Amount</th>
                <th align="center">Tax</th>
                <th align="center">Amount</th>
                <th align="center">Tax Amount</th>
                <th align="center">Sub Total <br /> Rs.</th>
            </tr>
            <tr>
                <td align="right">CGST</td>
                <td align="center"></td>
                <td align="center">9%</td>
                <td align="center"></td>
                <td align="center">
                    <?php echo e($is_igst_invoice ? '' : '' . Arr::get($invoice->tax_infos, 'total_cgst_amount')); ?></td>
                <td align="center"> </td>
            </tr>
            <tr>
                <td align="right">SGST</td>
                <td align="center"></td>
                <td align="center">9%</td>
                <td align="center"></td>
                <td align="center">
                    <?php echo e($is_igst_invoice ? '' : '' . Arr::get($invoice->tax_infos, 'total_sgst_amount')); ?></td>
                <td align="center"> <?php echo e($is_igst_invoice ? '' : '' . $invoice->total); ?></td>
            </tr>
            <tr>
                <td align="right">IGST</td>
                <td align="center"></td>
                <td align="center">18%</td>
                <td align="center"></td>
                <td align="center">
                    <?php echo e($is_igst_invoice ? '' . Arr::get($invoice->tax_infos, 'total_igst_amount') : ''); ?></td>
                <td align="center"> <?php echo e($is_igst_invoice ? '' . $invoice->total : ''); ?></td>
            </tr>
            <tr>
                <td align="right" colspan="5">Total Rs.</td>
                <td align="center"> <?php echo e($invoice->total); ?></td>
            </tr>
            <tr>
                <td colspan="6" height="12" style="text-transform: uppercase;">
                    RUPEES IN Word: <?php echo e(getIndianCurrencyInWord($invoice->total)); ?> only
                </td>
            </tr>
            <tr>
                <td colspan="6" height="80" style="text-transform: uppercase;">
                    <p class="p-pn">Customer's Singnature :</p>
                </td>
            </tr>
            <tr>
                <td colspan="1" height="50" style="text-transform: uppercase;">
                    <b>Terms & Conditions</b> <br />
                    1. Goods once sold will not be taken back <br />
                    2. Interest @12% pa. will be charged If the payment is not made with 15days. <br />
                    3. Warranty covered by the authonzed service center. <br />
                    PAN NO - AAQFT7886B <br />
                    This is a system generated Invoice. Thanks for doing business With us! <br />
                    Bank Details <br />
                    Bank Name : PUNJAB NATIONAL BANK <br />
                    Bank Account No. : 0100002100589323 Bank IFSC Code : PUNB0010000 <br />
                </td>
                <td colspan="5" height="80" style="text-transform: uppercase;" align="center" valign="top">
                    <b class="">For TRI INFOTEK SERVICES (LLP) Authorized Signatory</b>
                </td>
            </tr>

        </tbody>

    </table>
    <div style="border-right:1pt solid #000; padding-top: 10pt; display:none;">
        <table class="itemsTable"
            style="border:1pt solid black; border-collapse: collapse; border-right: 1pt solid #000" width="100%">
            <tbody>

                <tr>
                    <td colspan="8" style="border-top: 0pt;">&nbsp;</td>
                </tr>
                
                <tr style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;">
                    <td height="12" align="center" colspan="6">&nbsp;</td>
                    <th height="10" align="center"><strong>Grand Total</strong></th>
                    <td align="center">
                        <strong><?php echo e($invoice->total); ?></strong>
                    </td>
                </tr>
                <tr>
                    <td colspan="8" height="12" style="text-transform: uppercase;">
                        RUPEES IN Word: <?php echo e(getIndianCurrencyInWord($invoice->total)); ?> only
                    </td>
                </tr>
                <tr>
                    <td colspan="3"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif; border-right:0px solid #000;border-bottom: 0pt;"
                        d-width="47%" height="15">
                        
                    </td>
                    <td colspan="5"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;  border-left:0px solid #000;border-bottom: 0pt;"
                        width="47%" align="right">
                        
                    </td>
                </tr>
                
                <tr>

                    <td colspan="3"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif; border-right:0px solid #000;border-bottom:0pt;border-top: 0pt;"
                        d-width="47%" height="25" valign="top">
                        <strong>Customer's Signature :</strong>
                    </td>
                    <td colspan="5"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;  border-left:0px solid #000;border-bottom:0pt;border-top: 0pt;"
                        width="47%" align="right" valign="bottom">
                        <strong>E. & O. E.<br>
                            for Tri Infotek services LLP
                        </strong>
                    </td>
                </tr>
                <tr>

                    <td colspan="3"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif; border-right:0px solid #000;border-top: 0pt;"
                        d-width="47%" height="15">
                        <strong>Note : All disputes are in Howrah Jurisdiction. <br />
                            Payment will be made with 15 days failing which 12% <br />
                            interest will be charged on bill amount . <br />
                            Goods once sold can not be taken back.
                        </strong>
                    </td>
                    <td colspan="5"
                        style=" font-size:9px; color:#000; padding:5px; font-family: 'Muli', sans-serif;  border-left:0px solid #000;border-top: 0pt;"
                        width="47%" align="right" valign="bottom">
                        <strong>Authorised Signature</strong>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <script type="text/php">
        
        if (isset($pdf) && $PAGE_COUNT > 1) {
            $text = "Page {PAGE_NUM} / {PAGE_COUNT}";
            $size = 10;
            $font = $fontMetrics->getFont("Verdana");
            $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
            $x = ($pdf->get_width() - $width);
            $y = $pdf->get_height() - 20;
            $pdf->page_text($x, $y, $text, $font, $size);
        }
    </script>

</body>

</html>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/prints/client-invoice-task-v1.blade.php ENDPATH**/ ?>