<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('circle_product_pivot_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('dLMYg2B')) {
    $componentId = $_instance->getRenderedChildComponentId('dLMYg2B');
    $componentTag = $_instance->getRenderedChildComponentTagName('dLMYg2B');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('dLMYg2B');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('dLMYg2B', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('O8npINl')) {
    $componentId = $_instance->getRenderedChildComponentId('O8npINl');
    $componentTag = $_instance->getRenderedChildComponentTagName('O8npINl');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('O8npINl');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('O8npINl', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('HXzLpGW')) {
    $componentId = $_instance->getRenderedChildComponentId('HXzLpGW');
    $componentTag = $_instance->getRenderedChildComponentTagName('HXzLpGW');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('HXzLpGW');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CircleProductPivot','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('HXzLpGW', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.circleProductPivot.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.circleProductPivot.fields.product')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'product.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.circleProductPivot.fields.circle')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'circle.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.circleProductPivot.fields.quantity')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'quantity'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.circleProductPivot.fields.price')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'price'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.circleProductPivot.fields.last_updated_by')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'last_updated_by.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $circleProductPivots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $circleProductPivot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($circleProductPivot->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($circleProductPivot->id); ?>

                            </td>
                            <td>
                                <?php if($circleProductPivot->product): ?>
                                    <span class="badge badge-relationship"><?php echo e($circleProductPivot->product->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($circleProductPivot->circle): ?>
                                    <span class="badge badge-relationship"><?php echo e($circleProductPivot->circle->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($circleProductPivot->quantity); ?>

                            </td>
                            <td>
                                <?php echo e($circleProductPivot->price); ?>

                            </td>
                            <td>
                                <?php if($circleProductPivot->lastUpdatedBy): ?>
                                    <span class="badge badge-relationship"><?php echo e($circleProductPivot->lastUpdatedBy->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('circle_product_pivot_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.circle-product-pivots.show', $circleProductPivot)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('circle_product_pivot_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.circle-product-pivots.edit', $circleProductPivot)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('circle_product_pivot_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($circleProductPivot->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($circleProductPivots->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/circle-product-pivot/index.blade.php ENDPATH**/ ?>