<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_value_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('ZPRm5sz')) {
    $componentId = $_instance->getRenderedChildComponentId('ZPRm5sz');
    $componentTag = $_instance->getRenderedChildComponentTagName('ZPRm5sz');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('ZPRm5sz');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('ZPRm5sz', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('ixaf0wA')) {
    $componentId = $_instance->getRenderedChildComponentId('ixaf0wA');
    $componentTag = $_instance->getRenderedChildComponentTagName('ixaf0wA');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('ixaf0wA');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('ixaf0wA', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('14gZUDX')) {
    $componentId = $_instance->getRenderedChildComponentId('14gZUDX');
    $componentTag = $_instance->getRenderedChildComponentTagName('14gZUDX');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('14gZUDX');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LgAttributeValue','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('14gZUDX', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.lgAttributeValue.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttributeValue.fields.ledger_group_attribute')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'ledger_group_attribute.title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttributeValue.fields.value')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'value'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.lgAttributeValue.fields.so')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'so'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $lgAttributeValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lgAttributeValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($lgAttributeValue->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($lgAttributeValue->id); ?>

                            </td>
                            <td>
                                <?php if($lgAttributeValue->ledgerGroupAttribute): ?>
                                    <span class="badge badge-relationship"><?php echo e($lgAttributeValue->ledgerGroupAttribute->title ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($lgAttributeValue->value); ?>

                            </td>
                            <td>
                                <?php echo e($lgAttributeValue->so); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_value_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.lg-attribute-values.show', $lgAttributeValue)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_value_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.lg-attribute-values.edit', $lgAttributeValue)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lg_attribute_value_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($lgAttributeValue->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($lgAttributeValues->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/lg-attribute-value/index.blade.php ENDPATH**/ ?>