<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group <?php echo e($errors->has('jobDesignation.title') ? 'invalid' : ''); ?>">
        <label class="form-label" for="title"><?php echo e(trans('cruds.jobDesignation.fields.title')); ?></label>
        <input class="form-control" type="text" name="title" id="title" wire:model.defer="jobDesignation.title">
        <div class="validation-message">
            <?php echo e($errors->first('jobDesignation.title')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.jobDesignation.fields.title_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('jobDesignation.description') ? 'invalid' : ''); ?>">
        <label class="form-label" for="description"><?php echo e(trans('cruds.jobDesignation.fields.description')); ?></label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="jobDesignation.description" rows="4"></textarea>
        <div class="validation-message">
            <?php echo e($errors->first('jobDesignation.description')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.jobDesignation.fields.description_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('jobDesignation.basic_salary') ? 'invalid' : ''); ?>">
        <label class="form-label" for="basic_salary"><?php echo e(trans('cruds.jobDesignation.fields.basic_salary')); ?></label>
        <input class="form-control" type="number" name="basic_salary" id="basic_salary" wire:model.defer="jobDesignation.basic_salary" step="0.01">
        <div class="validation-message">
            <?php echo e($errors->first('jobDesignation.basic_salary')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.jobDesignation.fields.basic_salary_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('jobDesignation.basic_salary_max') ? 'invalid' : ''); ?>">
        <label class="form-label" for="basic_salary_max"><?php echo e(trans('cruds.jobDesignation.fields.basic_salary_max')); ?></label>
        <input class="form-control" type="number" name="basic_salary_max" id="basic_salary_max" wire:model.defer="jobDesignation.basic_salary_max" step="0.01">
        <div class="validation-message">
            <?php echo e($errors->first('jobDesignation.basic_salary_max')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.jobDesignation.fields.basic_salary_max_helper')); ?>

        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            <?php echo e(trans('global.save')); ?>

        </button>
        <a href="<?php echo e(route('admin.job-designations.index')); ?>" class="btn btn-secondary">
            <?php echo e(trans('global.cancel')); ?>

        </a>
    </div>
</form><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/job-designation/edit.blade.php ENDPATH**/ ?>