<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="flex flex-wrap">
        <div class="w-full pt-6 lg:w-64 lg:pt-0">
            <?php echo $__env->make('admin.message.nav-messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="w-1 flex-grow lg:pl-4">
            <div class="card bg-blueGray-100">
                <div class="card-header border-b border-blueGray-200">
                    <div class="flex flex-col lg:flex-row lg:justify-between">
                        <h6 class="card-title">
                            <?php echo e(__('global.new_message')); ?>

                        </h6>
                    </div>

                </div>

                <div class="card-body">
                    <form action="<?php echo e(route('admin.messages.store')); ?>" method="POST" class="pt-3">
                        <?php echo csrf_field(); ?>
                        <div class="form-group <?php echo e($errors->has('to') ? 'invalid' : ''); ?>">
                            <div class="flex flex-col lg:flex-row lg:items-center">
                                <label class="block uppercase text-blueGray-600 text-xs font-bold lg:w-20 pb-3 lg:pb-0" for="to">
                                    <?php echo e(__('global.to')); ?>

                                </label>
                                <select name="to[]" id="to" class="select2 form-control" required multiple>
                                    <option></option>
                                    <option value="null" disabled><?php echo e(__('global.pleaseSelect')); ?></option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"><?php echo e($email); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="validation-message">
                                <?php echo e($errors->first('to')); ?>

                            </div>
                        </div>
                        <div class="form-group <?php echo e($errors->has('subject') ? 'invalid' : ''); ?>">
                            <div class="flex flex-col lg:flex-row lg:items-center ">
                                <label class="block uppercase text-blueGray-600 text-xs font-bold lg:w-20 pb-3 lg:pb-0" for="subject">
                                    <?php echo e(__('global.subject')); ?>

                                </label>
                                <input class="form-control" type="text" name="subject" id="subject" required placeholder="<?php echo e(__('global.subject')); ?>">
                            </div>
                            <div class="validation-message">
                                <?php echo e($errors->first('subject')); ?>

                            </div>
                        </div>
                        <div class="form-group <?php echo e($errors->has('body') ? 'invalid' : ''); ?>">
                            <textarea class="form-control" name="body" id="body" required rows="8" placeholder="<?php echo e(__('global.body')); ?>"></textarea>
                            <div class="validation-message">
                                <?php echo e($errors->first('body')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-indigo mr-2" type="submit">
                                <?php echo e(trans('global.send')); ?>

                            </button>
                            <a href="<?php echo e(route('admin.messages.index')); ?>" class="btn btn-secondary">
                                <?php echo e(trans('global.discard')); ?>

                            </a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(function(){
    $('#to').select2({
        placeholder: '<?php echo e(__('global.pleaseSelect')); ?>',
        allowClear: false
    })
});
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/message/create.blade.php ENDPATH**/ ?>