<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.crmCustomer.title_singular')); ?>:
                    <?php echo e(trans('cruds.crmCustomer.fields.id')); ?>

                    <?php echo e($crmCustomer->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.first_name')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->first_name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.last_name')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->last_name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.status')); ?>

                            </th>
                            <td>
                                <?php if($crmCustomer->status): ?>
                                    <span class="badge badge-relationship"><?php echo e($crmCustomer->status->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.email')); ?>

                            </th>
                            <td>
                                <a class="link-light-blue" href="mailto:<?php echo e($crmCustomer->email); ?>">
                                    <i class="far fa-envelope fa-fw">
                                    </i>
                                    <?php echo e($crmCustomer->email); ?>

                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.phone')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->phone); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.address')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->address); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.skype')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->skype); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.website')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->website); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.crmCustomer.fields.description')); ?>

                            </th>
                            <td>
                                <?php echo e($crmCustomer->description); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_customer_edit')): ?>
                    <a href="<?php echo e(route('admin.crm-customers.edit', $crmCustomer)); ?>" class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.crm-customers.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/crm-customer/show.blade.php ENDPATH**/ ?>