<div>
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('ZYSg8ho')) {
    $componentId = $_instance->getRenderedChildComponentId('ZYSg8ho');
    $componentTag = $_instance->getRenderedChildComponentTagName('ZYSg8ho');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('ZYSg8ho');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('ZYSg8ho', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('AC4wn9U')) {
    $componentId = $_instance->getRenderedChildComponentId('AC4wn9U');
    $componentTag = $_instance->getRenderedChildComponentTagName('AC4wn9U');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('AC4wn9U');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('AC4wn9U', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('1dQvdsE')) {
    $componentId = $_instance->getRenderedChildComponentId('1dQvdsE');
    $componentTag = $_instance->getRenderedChildComponentTagName('1dQvdsE');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('1dQvdsE');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'Service','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('1dQvdsE', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.service.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.service.fields.name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.service.fields.description')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.product.fields.hsn_code')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'hsn_code'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.product.fields.taxable_price')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'taxable_price'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.service.fields.price')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'price'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($service->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($service->id); ?>

                            </td>
                            <td>
                                <?php echo e($service->name); ?>

                            </td>
                            <td>
                                <?php echo e($service->description); ?>

                            </td>
                            <td>
                                <?php echo e($service->hsn_code); ?>

                            </td>
                            <td>
                                <?php echo e($service->taxable_price); ?>

                            </td>
                            <td>
                                <?php echo e($service->price); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2"
                                            href="<?php echo e(route('admin.services.show', $service)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2"
                                            href="<?php echo e(route('admin.services.edit', $service)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button"
                                            wire:click="confirm('delete', <?php echo e($service->id); ?>)"
                                            wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($services->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
                return
            }
            window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/service/index.blade.php ENDPATH**/ ?>