<?php $__env->startSection('content'); ?>
    <section class="relative w-full h-full py-40 min-h-screen">
        <div class="container mx-auto px-4 h-full">
            <div class="flex content-center items-center justify-center h-full">
                <div class="w-full lg:w-4/12 px-4">
                    <div
                        class="relative flex flex-col min-w-0 break-words w-full mb-6 shadow-lg rounded-lg bg-blueGray-200 border-0">
                        <div class="rounded-t mb-0 px-6 py-6">
                            <div class="text-center mb-3">
                                <h6 class="text-blueGray-500 text-sm font-bold">
                                    <?php echo e(__('global.login')); ?>

                                </h6>
                            </div>
                            <hr class="mt-6 border-b-1 border-blueGray-300" />
                        </div>
                        <div class="flex-auto px-4 lg:px-10 py-10 pt-0">
                            <form method="POST" action="<?php echo e(route('login')); ?>" onsubmit="frmSubmit()">
                                <?php echo csrf_field(); ?>
                                <div class="relative w-full mb-3">
                                    <label class="block uppercase text-blueGray-600 text-xs font-bold mb-2" for="email">
                                        <?php echo e(__('global.login_email')); ?>

                                    </label>
                                    <input id="email" name="email" type="text"
                                        class="border-0 px-3 py-3 placeholder-blueGray-300 text-blueGray-600 bg-white rounded text-sm shadow focus:outline-none focus:ring w-full <?php echo e($errors->has('email') ? ' ring ring-red-300' : ''); ?>"
                                        placeholder="<?php echo e(__('global.login_email')); ?>" required autocomplete="email" autofocus
                                        value="<?php echo e(old('email')); ?>" />
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-red-500">
                                            <small><?php echo e($message); ?></small>
                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="relative w-full mb-3">
                                    <label class="block uppercase text-blueGray-600 text-xs font-bold mb-2" for="password">
                                        <?php echo e(__('global.login_password')); ?>

                                    </label>
                                    <input id="password" name="password" type="password"
                                        class="border-0 px-3 py-3 placeholder-blueGray-300 text-blueGray-600 bg-white rounded text-sm shadow focus:outline-none focus:ring w-full <?php echo e($errors->has('password') ? ' ring ring-red-300' : ''); ?>"
                                        placeholder="<?php echo e(__('global.login_password')); ?>" required
                                        autocomplete="current-password" />
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-red-500">
                                            <small><?php echo e($message); ?></small>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div>
                                    <label class="inline-flex items-center cursor-pointer"><input id="remember"
                                            name="remember" type="checkbox"
                                            class="form-checkbox border-0 rounded text-blueGray-700 ml-1 w-5 h-5 ease-linear transition-all duration-150"
                                            <?php echo e(old('remember') ? 'checked' : ''); ?> />
                                        <span class="ml-2 text-sm font-semibold text-blueGray-600">
                                            <?php echo e(__('global.remember_me')); ?>

                                        </span>
                                    </label>
                                </div>
                                <div class="text-center mt-6">
                                    <button id="loginbtn"
                                        class="bg-blueGray-800 text-white active:bg-blueGray-600 text-sm font-bold uppercase px-6 py-3 rounded shadow hover:shadow-lg outline-none focus:outline-none mr-1 mb-1 w-full ease-linear transition-all duration-150">
                                        <?php echo e(__('global.login')); ?>

                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="flex flex-wrap mt-6">
                        <div class="w-1/2">
                            <?php if(Route::has('password.request')): ?>
                                <a href="<?php echo e(route('password.request')); ?>" class="text-blueGray-200">
                                    <small><?php echo e(__('global.forgot_password')); ?></small>
                                </a>
                            <?php endif; ?>
                        </div>
                        <div class="w-1/2 text-right">
                            <?php if(Route::has('register')): ?>
                                <a href="<?php echo e(route('register')); ?>" class="text-blueGray-200">
                                    <small><?php echo e(__('global.register')); ?></small>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        function frmSubmit() {
            let loginbtn = document.querySelector("#loginbtn");
            loginbtn.disabled = true;
            let handler = window.setTimeout(() => {
                loginbtn.disabled = false;
            }, 2000);
        }
    </script>
    <style>
        #loginbtn:disabled {
            opacity: 0.4 !important;
            background-color: rgb(74 60 60 / 64%) !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/auth/login.blade.php ENDPATH**/ ?>