<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="card bg-blueGray-100">
            <div class="card-header">
                <div class="card-header-container">
                    <h6 class="card-title">
                        <?php echo e(trans('global.view')); ?>

                        <?php echo e(trans('cruds.employeeAttendanceLog.title_singular')); ?>:
                        <?php echo e(trans('cruds.employeeAttendanceLog.fields.id')); ?>

                        <?php echo e($employeeAttendanceLog->id); ?>

                    </h6>
                </div>
            </div>

            <div class="card-body">
                <div class="pt-3">
                    <table class="table table-view">
                        <tbody class="bg-white">
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.id')); ?>

                                </th>
                                <td>
                                    <?php echo e($employeeAttendanceLog->id); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.date')); ?>

                                </th>
                                <td>
                                    <?php echo e($employeeAttendanceLog->date); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.user')); ?>

                                </th>
                                <td>
                                    <?php if($employeeAttendanceLog->user): ?>
                                        <span
                                            class="badge badge-relationship"><?php echo e($employeeAttendanceLog->user->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            
                            
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.location')); ?>

                                </th>
                                <td>
                                    

                                    <div class="grid grid-cols-2 gap-1 md:mr-10">
                                        <div class="text-sm font-black">Location in Text</div>
                                        <div class="text-xs"><?php echo e($employeeAttendanceLog->location); ?></div>
                                        
                                        <div class="text-sm font-black">Lat:</div>
                                        <div class="text-xs"><?php echo e($employeeAttendanceLog->coord_lat); ?></div>
                                        
                                        <div class="text-sm font-black">Long:</div>
                                        <div class="text-xs"><?php echo e($employeeAttendanceLog->coord_long); ?></div>
                                        
                                        <div class="text-sm font-black">Accuracy</div>
                                        <div class="text-xs"><?php echo e($employeeAttendanceLog->coord_accu); ?></div>
                                        
                                    </div>

                                    <a href="<?php echo e($employeeAttendanceLog->gmap_url1); ?>" class="text-blue" target="__<?php echo e(uniqid()); ?>">View</a>
                                </td>
                            </tr>


                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.signed_in_at')); ?>

                                </th>
                                <td>
                                    <?php echo e($employeeAttendanceLog->signed_in_at); ?>

                                </td>
                            </tr>
                            
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.sign_in_photo')); ?>

                                </th>
                                <td>
                                    <?php $__currentLoopData = $employeeAttendanceLog->sign_in_photo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="link-photo" href="<?php echo e($entry['url']); ?>">
                                            <img src="<?php echo e($entry['preview_thumbnail']); ?>" alt="<?php echo e($entry['name']); ?>"
                                                title="<?php echo e($entry['name']); ?>">
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                            
                            
                            
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.employeeAttendanceLog.fields.task')); ?>

                                </th>
                                <td>
                                    <?php $__currentLoopData = $employeeAttendanceLog->task; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-relationship"><?php echo e($entry->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="form-group">
                    
                    <a href="<?php echo e(route('admin.employee-attendance-logs.index')); ?>" class="btn btn-secondary">
                        <?php echo e(trans('global.back')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/employee-attendance-log/show.blade.php ENDPATH**/ ?>