<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="flex flex-wrap">
        <div class="w-full pt-6 lg:w-64 lg:pt-0">
            <?php echo $__env->make('admin.message.nav-messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="w-1 flex-grow lg:pl-4" x-data="{ replyHidden: true }">
            <div class="card bg-white">
                <div class="card-header border-b border-blueGray-200">
                    <div class="flex flex-col lg:flex-row lg:justify-between">
                        <h6 class="card-title">
                            <?php echo e($conversation->subject); ?>

                            <div>
                                <div class="font-normal text-sm block">
                                    <?php echo e(__('global.from')); ?>:
                                    <?php echo e($conversation->owner->name); ?>

                                    &lt;<?php echo e($conversation->owner->email); ?>&gt;
                                </div>
                                <div class="font-normal text-sm block">
                                    <?php echo e(__('global.to')); ?>:
                                    <?php $__currentLoopData = $conversation->recipients->reject(function($user) use ($conversation) {
                                        return $user->id === $conversation->owner_id;
                                        }); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($user->name); ?>

                                        &lt;<?php echo e($user->email); ?>&gt;<?php echo e(!$loop->last ? ', ' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </h6>

                        <button @click="replyHidden = false" class="btn btn-indigo w-full self-start lg:w-auto" type="button">
                            <?php echo e(__('global.reply')); ?>

                        </button>
                    </div>

                </div>

                <div class="card-body bg-blueGray-100 hidden" :class="{ 'hidden': replyHidden === true }">
                    <form action="<?php echo e(route('admin.messages.update', $conversation)); ?>" method="POST" class="pt-3">
                        <?php echo csrf_field(); ?>
                        <div class="form-group <?php echo e($errors->has('body') ? 'invalid' : ''); ?>">
                            <textarea class="form-control" name="body" id="body" rows="8" required placeholder="<?php echo e(__('global.body')); ?>"></textarea>
                            <div class="validation-message">
                                <?php echo e($errors->first('body')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-indigo w-full self-start lg:w-auto mr-2" type="submit">
                                <?php echo e(__('global.send')); ?>

                            </button>
                            <button @click="replyHidden = true" type="button" class="btn btn-secondary">
                                <?php echo e(__('global.discard')); ?>

                            </button>
                        </div>
                    </form>
                </div>

                <div class="card-body">
                    <div class="flex flex-col pt-3">
                        <?php $__currentLoopData = $conversation->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-1">
                                <div class="<?php echo e((int) $message->user_id === (int) auth()->id() ? 'bg-indigo-100 divide-indigo-300 ml-6' : 'bg-blueGray-100 divide-blueGray-300'); ?> inline-block px-4 py-3 rounded divide-y divide-solid">
                                    <div class="text-sm text-blueGray-500 pb-3">
                                        From: <?php echo e($message->user->name); ?> &lt;<?php echo e($message->user->email); ?>&gt;<br>
                                        <?php echo e($message->created_at->diffForHumans()); ?>

                                    </div>
                                    <pre class="font-sans whitespace-pre-wrap pt-6" style="font-size:0.9375rem"><?php echo e($message->body); ?></pre>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/message/show.blade.php ENDPATH**/ ?>