<?php

use App\Http\Controllers\Api\V1\Admin\CircleApiController;
use App\Http\Controllers\Api\V1\Admin\ClientApiController;
use App\Http\Controllers\Api\V1\Admin\ClientBranchApiController;
use App\Http\Controllers\Api\V1\Admin\ClientGroupApiController;
use App\Http\Controllers\Api\V1\Admin\CompanyApiController;
use App\Http\Controllers\Api\V1\Admin\FinYrApiController;
use App\Http\Controllers\Api\V1\Admin\LedgerApiController;
use App\Http\Controllers\Api\V1\Admin\LedgerGroupApiController;
use App\Http\Controllers\Api\V1\Admin\PurchaseApiController;
use App\Http\Controllers\Api\V1\Admin\RegionApiController;
use App\Http\Controllers\Api\V1\Admin\SpecialPlannedDayApiController;
use App\Http\Controllers\Api\V1\Admin\StateApiController;
use App\Http\Controllers\Api\V1\Admin\ZoneApiController;
use App\Http\Controllers\Api\V1\App\AppController;
use App\Http\Controllers\Api\V1\User\ApiAuthController;
use Illuminate\Support\Facades\Route;

// header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
// header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token, Authorization, Accept,charset,boundary,Content-Length');
// header('Access-Control-Allow-Origin: *');

Route::group([
    'prefix' => 'v1', 'as' => 'api.',
    /* 'middleware' => ['auth:sanctum'] */
    // 'middleware' => ['cors'],
], function () {
    Route::post('login', [ApiAuthController::class, 'login'])->name('login');





    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::get('logout', [ApiAuthController::class, 'logout'])->name('logout');

        Route::get('user', [ApiAuthController::class, 'getUser'])->name('user');
        Route::post('app-menu', [ApiAuthController::class, 'getAppMenu'])->name('app-menu');
        Route::post('change-password', [ApiAuthController::class, 'changePassword'])->name('change-password');
        Route::get('me', [ApiAuthController::class, 'getUser'])->name('me');
        Route::post('user/attendance/give', [ApiAuthController::class, 'giveAttendance'])->name('give-attendance');
        Route::get('user/attendance', [ApiAuthController::class, 'allAttendances'])->name('all-attendance');
        Route::get('user/tasks', [ApiAuthController::class, 'tasks'])->name('all-tasks');
        Route::get('user/engineers', [ApiAuthController::class, 'engineers'])->name('all-engineers');
        Route::post('user/payslips', [ApiAuthController::class, 'paySlips'])->name('all-payslips');
        Route::get('user/tasks/{task}/detailed', [ApiAuthController::class, 'taskDetailed'])->name('tasks-detailed');
        Route::post('user/tasks/{task}/change-engineer', [ApiAuthController::class, 'ChangeEngineer'])->name('change-engineer');
        Route::post('user/tasks/{task}/change-status', [ApiAuthController::class, 'ChangeStatus'])->name('change-status');
        Route::post('user/tasks/{task}/attendance', [ApiAuthController::class, 'giveTaskAttendance'])->name('tasks-attendance');
        Route::post('user/tasks/{task}/close', [ApiAuthController::class, 'closeTask'])->name('tasks-close');
        Route::post('user/my-visits', [ApiAuthController::class, 'MyVisits'])->name('my-visits');
        Route::post('user/my-visits/{visit}/add-reimbursement', [ApiAuthController::class, 'addReimbursementRouteData'])->name('my-visits.add-reimbursement');
        Route::get('user/my-visits/reimbursement-config', [ApiAuthController::class, 'reimbursementCfg'])->name('my-visits.reimbursement-config');
        Route::get('user/reimbursements', [ApiAuthController::class, 'reimbursements'])->name('my-reimbursements');
        Route::get('category/{category}/products', [ApiAuthController::class, 'bringProductsByCategory'])->name('products-by-category');
        Route::post('user/tasks/{task}/request-products', [ApiAuthController::class, 'requestProducts'])->name('request-products');
        Route::post('user/tasks/{task}/timeline', [ApiAuthController::class, 'timeline'])->name('task-timeline');

        // Ledger Group
        Route::apiResource('ledger-groups', LedgerGroupApiController::class);

        // Zone
        Route::apiResource('zones', ZoneApiController::class);

        // Circle
        Route::apiResource('circles', CircleApiController::class);


        // Region
        Route::apiResource('regions', RegionApiController::class);

        // Client Group
        Route::apiResource('client-groups', ClientGroupApiController::class);

        // State
        Route::apiResource('states', StateApiController::class);

        // Company
        Route::apiResource('companies', CompanyApiController::class);

        // Purchase
        Route::apiResource('purchases', PurchaseApiController::class);

        // Special Planned Day
        Route::apiResource('special-planned-days', SpecialPlannedDayApiController::class);

        // Ledger
        Route::apiResource('ledgers', LedgerApiController::class);

        // Fin Yr
        Route::apiResource('fin-yrs', FinYrApiController::class);

        // Client
        Route::apiResource('clients', ClientApiController::class);

        // Client Branch
        Route::apiResource('client-branches', ClientBranchApiController::class);
    });



    Route::get('app/prod/settings', [AppController::class, 'maintenanceData']);
    Route::get('app/prod/maintenance', [AppController::class, 'maintenanceData']);
    Route::get('app/prod/update', [AppController::class, 'updateData']);
    Route::post('app/ota-update-url', [AppController::class, 'otaUpdateData']);
});
