<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('zone.name') ? 'invalid' : '' }}">
        <label class="form-label required" for="name">{{ trans('cruds.zone.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" required wire:model.defer="zone.name">
        <div class="validation-message">
            {{ $errors->first('zone.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.zone.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('zone.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="zone.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.zone.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('zone.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.zone.fields.is_active_helper') }}
        </div>
    </div>

    <div class="form-group {{ $errors->has('zone.state_id') ? 'invalid' : '' }}">
        <label class="form-label" for="state">{{ trans('cruds.zone.fields.state') }}</label>
        <x-select-list class="form-control" id="state" name="state" :options="$this->listsForFields['states']" wire:model="zone.state_id" />
        <div class="validation-message">
            {{ $errors->first('zone.state_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.zone.fields.state_helper') }}
        </div>
    </div>

    <div class="form-group {{ $errors->has('zone.zonal_officer_id') ? 'invalid' : '' }}">
        <label class="form-label" for="zonal_officer">{{ trans('cruds.zone.fields.zonal_officer') }}</label>
        <x-select-list class="form-control" id="zonal_officer" name="zonal_officer" :options="$this->listsForFields['zonal_officers']" wire:model="zone.zonal_officer_id" />
        <div class="validation-message">
            {{ $errors->first('zone.zonal_officer_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.zone.fields.zonal_officer_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.zones.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
