<div wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')
    {{-- <pre>@json($state['stock'])</pre> --}}
    @if ($zone)
        <div class=" px-2 ">
            <label class="form-label required" for="categories">Filter by categories</label>
            <x-tags-list class="form-control" required id="categories" name="categories" wire:model="filters.categories"
                :options="$this->listsForFields['categories']" multiple />

        </div>
        <div class="relative">

            <div class="hidden x-flex items-center w-full mb-2">
                <label for="simple-search" class="sr-only">Search</label>
                <div class="relative  w-full">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <input type="text" id="simpleSearchInput"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Search" required>
                </div>
                <button type="button" onclick="simpleSearchInput.value=''"
                    class="p-2.5 ml-2 text-sm font-medium text-white bg-blue-700 rounded-lg border border-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-5 h-5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    <span class="sr-only">Search</span>
                </button>
            </div>
            <div class="overflow-x-auto mb-3">
                <table class="table table-index w-full">
                    <thead>
                        <tr>
                            <th>Product Name/Description</th>
                            {{-- <th>Price</th> --}}
                            <th>Current Stock</th>
                            {{-- <th>Stock To Add</th> --}}
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $p)
                            <tr class="" id="{{ uniqid() }}">
                                <td>
                                    <code>#{{ $p->id }}</code>
                                    <span> {{ $p->name }} </span>
                                    <span class="text-2xs block"> {{ $p->description }} </span>
                                </td>
                                {{-- <td>
                                    ₹{{ $p->price }}
                                </td> --}}
                                <td>
                                    {{ $p->stock }}
                                </td>
                                {{-- <td>
                                    <div
                                        class="form-group {{ $errors->has("state.stock.{$p->id}.add") ? 'invalid' : '' }}">
                                        <input type="number" class="w-[150px]"
                                            wire:model.defer="state.stock.{{ $p->id }}.add" min="0" />
                                        <div class="validation-message text-xs">
                                            {{ $errors->first("state.stock.{$p->id}.add") }}
                                        </div>
                                    </div>
                                </td> --}}
                            </tr>
                        @endforeach
                        @if ($products->count() == 0)
                            <tr>
                                <td class="text-center py-2" colspan="4">
                                    No products found
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            {{-- @if ($products->count() > 0)
                <div
                    class="bg-gray-100 text-3xl text-white text-right sticky inset-x-0 bottom-5 p-4 shadow-lg drop-shadow-lg">

                    <button class="btn btn-indigo mr-2" wire:click="addStocks" type="button">
                        Add Stocks
                    </button>
                </div>
            @endif --}}
        </div>
    @endif

    {{-- <div class="form-group {{ $errors->has('productZonePivot.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.productZonePivot.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="productZonePivot.product_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.productZonePivot.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="productZonePivot.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.price') ? 'invalid' : '' }}">
        <label class="form-label" for="price">{{ trans('cruds.productZonePivot.fields.price') }}</label>
        <input class="form-control" type="number" name="price" id="price" wire:model.defer="productZonePivot.price" step="0.01">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.price') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.price_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.last_updated_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="last_updated_by">{{ trans('cruds.productZonePivot.fields.last_updated_by') }}</label>
        <x-select-list class="form-control" id="last_updated_by" name="last_updated_by" :options="$this->listsForFields['last_updated_by']" wire:model="productZonePivot.last_updated_by_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.last_updated_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.last_updated_by_helper') }}
        </div>
    </div>
     --}}
    {{--
    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.product-zone-pivots.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div> --}}
</div>

@push('scripts')
    <script>
        $.ready(function() {
            $(document).on('input', "#simpleSearchInput", function() {
                var value = $(this).val().toLowerCase();
                console.log("value", value)
                $("#simpleSearchTable tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            })
        })
    </script>
@endpush
