<div wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')
    {{-- <pre>@json($state['stock'])</pre> --}}
    @if ($zone)
        <div class="relative">

            <div class="overflow-x-auto mb-3">
                <table class="table table-index w-full">
                    <thead>
                        <tr>
                            <th>Product Name/Description</th>
                            {{-- <th>Price</th> --}}
                            <th>Type</th>
                            <th>Current Stock</th>
                            <th>Requested Quantity</th>
                            {{-- <th>Requested Quantity</th> --}}
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($productRequests as $p)
                            @php
                                $stockAvailable = $cStock($p->product_id);
                                $canAccept = $stockAvailable >= $p->requested_quantity;
                                $needAccept = $stockAvailable >= $p->quantity;
                                $needQuantity = $p->requested_quantity - $stockAvailable;

                            @endphp
                            <tr class="" id="{{ uniqid() }}">
                                <td>
                                    <code>#{{ $p->id }}</code>
                                    <span> {{ $p->p_name }} </span>
                                    <span class="text-2xs block"> {{ $p->p_description }} </span>
                                </td>
                                {{-- <td>
                                    ₹{{ $p->price }}
                                </td> --}}
                                <td>
                                    {{ $p->p_listed ? 'Listed' : 'Unlisted' }}
                                </td>
                                <td>
                                    {{ $stockAvailable }}
                                </td>
                                <td>
                                    {{ $p->requested_quantity }}
                                </td>

                                <td>

                                    @if ($canAccept)
                                        @if ($p->status == 'accepted')
                                            <span class="text-sm">Product Sent</span>
                                        @else
                                            <button type="button" class="btn btn-primary btn-sm"
                                                wire:click="acceptProductRequest('{{ $p->product_id }}','{{ $p->id }}')">Accept
                                                And Send</button>
                                        @endif
                                    @else
                                        {{-- <button type="button" class="btn btn-primary btn-sm disabled opacity-75" disabled >Accept And Send</button> --}}
                                        {{-- @if ($p->status == 'requested')
                                            <span class="text-sm">Already Requested</span>
                                        @else
                                            <button type="button" class="btn btn-primary btn-sm"
                                                wire:click="requestProductToZonal('{{ $p->product_id }}','{{ $needQuantity }}',{{ json_encode($p) }})">Request
                                                to Zonal Office</button>
                                        @endif --}}
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        @if ($productRequests->count() == 0)
                            <tr>
                                <td class="text-center py-2" colspan="4">
                                    No products found
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            {{-- @if ($products->count() > 0)
                <div
                    class="bg-gray-100 text-3xl text-white text-right sticky inset-x-0 bottom-5 p-4 shadow-lg drop-shadow-lg">

                    <button class="btn btn-indigo mr-2" wire:click="addStocks" type="button">
                        Add Stocks
                    </button>
                </div>
            @endif --}}
        </div>
    @endif

    {{-- <div class="form-group {{ $errors->has('productZonePivot.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.productZonePivot.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="productZonePivot.product_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.productZonePivot.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="productZonePivot.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.price') ? 'invalid' : '' }}">
        <label class="form-label" for="price">{{ trans('cruds.productZonePivot.fields.price') }}</label>
        <input class="form-control" type="number" name="price" id="price" wire:model.defer="productZonePivot.price" step="0.01">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.price') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.price_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.last_updated_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="last_updated_by">{{ trans('cruds.productZonePivot.fields.last_updated_by') }}</label>
        <x-select-list class="form-control" id="last_updated_by" name="last_updated_by" :options="$this->listsForFields['last_updated_by']" wire:model="productZonePivot.last_updated_by_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.last_updated_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.last_updated_by_helper') }}
        </div>
    </div>
     --}}
    {{--
    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.product-zone-pivots.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div> --}}
</div>

@push('scripts')
    <script>
        $.ready(function() {
            $(document).on('input', "#simpleSearchInput", function() {
                var value = $(this).val().toLowerCase();
                console.log("value", value)
                $("#simpleSearchTable tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            })
        })
    </script>
@endpush
