<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('visit_route_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="VisitRoute" format="csv" />
                <livewire:excel-export model="VisitRoute" format="xlsx" />
                <livewire:excel-export model="VisitRoute" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.visitRoute.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.from') }}
                            @include('components.table.sort', ['field' => 'from'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.to') }}
                            @include('components.table.sort', ['field' => 'to'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.journey_distance') }}
                            @include('components.table.sort', ['field' => 'journey_distance'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.journey_fare') }}
                            @include('components.table.sort', ['field' => 'journey_fare'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.vehicle_type') }}
                            @include('components.table.sort', ['field' => 'vehicle_type'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.journey_type') }}
                            @include('components.table.sort', ['field' => 'journey_type'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.note') }}
                            @include('components.table.sort', ['field' => 'note'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.route_cost') }}
                            @include('components.table.sort', ['field' => 'route_cost'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.user') }}
                            @include('components.table.sort', ['field' => 'user.name'])
                        </th>
                        <th>
                            {{ trans('cruds.visitRoute.fields.reimbursement') }}
                            @include('components.table.sort', ['field' => 'reimbursement.amount'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.amount') }}
                            @include('components.table.sort', ['field' => 'reimbursement.amount'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($visitRoutes as $visitRoute)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $visitRoute->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $visitRoute->id }}
                            </td>
                            <td>
                                {{ $visitRoute->from }}
                            </td>
                            <td>
                                {{ $visitRoute->to }}
                            </td>
                            <td>
                                {{ $visitRoute->journey_distance }}
                            </td>
                            <td>
                                {{ $visitRoute->journey_fare }}
                            </td>
                            <td>
                                {{ $visitRoute->vehicle_type_label }}
                            </td>
                            <td>
                                {{ $visitRoute->journey_type_label }}
                            </td>
                            <td>
                                {{ $visitRoute->note }}
                            </td>
                            <td>
                                {{ $visitRoute->route_cost }}
                            </td>
                            <td>
                                @if($visitRoute->user)
                                    <span class="badge badge-relationship">{{ $visitRoute->user->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($visitRoute->reimbursement)
                                    <span class="badge badge-relationship">{{ $visitRoute->reimbursement->amount ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($visitRoute->reimbursement)
                                    {{ $visitRoute->reimbursement->amount ?? '' }}
                                @endif
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('visit_route_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.visit-routes.show', $visitRoute) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('visit_route_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.visit-routes.edit', $visitRoute) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('visit_route_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $visitRoute->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $visitRoutes->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush