<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('visit_reimbursement_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="VisitReimbursement" format="csv" />
                <livewire:excel-export model="VisitReimbursement" format="xlsx" />
                <livewire:excel-export model="VisitReimbursement" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.visitReimbursement.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.user') }}
                            @include('components.table.sort', ['field' => 'user.name'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.task') }}
                            @include('components.table.sort', ['field' => 'task.name'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.approved_by') }}
                            @include('components.table.sort', ['field' => 'approved_by.name'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.approved_at') }}
                            @include('components.table.sort', ['field' => 'approved_at'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.amount') }}
                            @include('components.table.sort', ['field' => 'amount'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.visit') }}
                            @include('components.table.sort', ['field' => 'visit.date'])
                        </th>
                        <th>
                            {{ trans('cruds.visitReimbursement.fields.status') }}
                            @include('components.table.sort', ['field' => 'status'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($visitReimbursements as $visitReimbursement)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $visitReimbursement->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $visitReimbursement->id }}
                            </td>
                            <td>
                                @if($visitReimbursement->user)
                                    <span class="badge badge-relationship">{{ $visitReimbursement->user->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($visitReimbursement->task)
                                    <span class="badge badge-relationship">{{ $visitReimbursement->task->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($visitReimbursement->approvedBy)
                                    <span class="badge badge-relationship">{{ $visitReimbursement->approvedBy->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $visitReimbursement->approved_at }}
                            </td>
                            <td>
                                {{ $visitReimbursement->amount }}
                            </td>
                            <td>
                                @if($visitReimbursement->visit)
                                    <span class="badge badge-relationship">{{ $visitReimbursement->visit->date ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $visitReimbursement->status_label }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('visit_reimbursement_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.visit-reimbursements.show', $visitReimbursement) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('visit_reimbursement_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.visit-reimbursements.edit', $visitReimbursement) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('visit_reimbursement_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $visitReimbursement->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $visitReimbursements->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush