<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')

    <div class="form-group {{ $errors->has('user.name') ? 'invalid' : '' }}">
        <label class="form-label required" for="name">{{ trans('cruds.user.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" required wire:model.defer="user.name">
        <div class="validation-message">
            {{ $errors->first('user.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.email') ? 'invalid' : '' }}">
        <label class="form-label required" for="email">{{ trans('cruds.user.fields.email') }}</label>
        <input class="form-control" type="email" name="email" id="email" required wire:model.defer="user.email">
        <div class="validation-message">
            {{ $errors->first('user.email') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.email_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.password') ? 'invalid' : '' }}">
        <label class="form-label" for="password">{{ trans('cruds.user.fields.password') }}</label>
        <input class="form-control" type="password" name="password" id="password" wire:model.defer="password">
        <div class="validation-message">
            {{ $errors->first('user.password') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.password_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('roles') ? 'invalid' : '' }}">
        <label class="form-label required" for="roles">{{ trans('cruds.user.fields.roles') }}</label>
        <x-select-list class="form-control" required id="roles" name="roles" wire:model="roles" :options="$this->listsForFields['roles']" multiple />
        <div class="validation-message">
            {{ $errors->first('roles') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.roles_helper') }}
        </div>
    </div>
    {{-- <div class="form-group {{ $errors->has('roles') ? 'invalid' : '' }}">
        <label class="form-label required" for="roles">{{ trans('cruds.user.fields.roles') }}</label>
        <x-tags-list class="form-control" required id="roles" name="roles" wire:model="roles" :options="$this->listsForFields['roles']" multiple />
        <div class="validation-message">
            {{ $errors->first('roles') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.roles_helper') }}
        </div>
    </div> --}}
    <div class="form-group {{ $errors->has('user.locale') ? 'invalid' : '' }}">
        <label class="form-label" for="locale">{{ trans('cruds.user.fields.locale') }}</label>
        <input class="form-control" type="text" name="locale" id="locale" wire:model.defer="user.locale">
        <div class="validation-message">
            {{ $errors->first('user.locale') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.locale_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.phone') ? 'invalid' : '' }}">
        <label class="form-label" for="phone">{{ trans('cruds.user.fields.phone') }}</label>
        <input class="form-control" type="text" name="phone" id="phone" wire:model.defer="user.phone">
        <div class="validation-message">
            {{ $errors->first('user.phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.username') ? 'invalid' : '' }}">
        <label class="form-label" for="username">{{ trans('cruds.user.fields.username') }}</label>
        <input class="form-control" type="text" name="username" id="username" wire:model.defer="user.username">
        <div class="validation-message">
            {{ $errors->first('user.username') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.username_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.employee_code') ? 'invalid' : '' }}">
        <label class="form-label" for="employee_code">{{ trans('cruds.user.fields.employee_code') }}</label>
        <input class="form-control" type="text" name="employee_code" id="employee_code" wire:model.defer="user.employee_code">
        <div class="validation-message">
            {{ $errors->first('user.employee_code') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.employee_code_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="user.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.user.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('user.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.is_active_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('user.last_password_changed_at') ? 'invalid' : '' }}">
        <label class="form-label" for="last_password_changed_at">{{ trans('cruds.user.fields.last_password_changed_at') }}</label>
        <x-date-picker class="form-control" wire:model="user.last_password_changed_at" id="last_password_changed_at" name="last_password_changed_at" />
        <div class="validation-message">
            {{ $errors->first('user.last_password_changed_at') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.user.fields.last_password_changed_at_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
