<div>
    <div class="py-2 px-4">
        <h2>Assign Engineer</h2>
        <section class="py-4 px-4 text-gray-600 body-font  h-6/5">
            @include('components.loading-spinner-full-page')
            <form wire:submit.prevent="submit" class="pt-3">
                {{-- @json($listsForFields['engineers']) --}}
                {{-- @dump($listsForFields['engineers']) --}}
                <div class="form-group {{ $errors->has('task.engineer_id') ? 'invalid' : '' }}">
                    <label class="form-label required" for="assigned_to_id">Chose an engineer</label>
                    <x-select-list class="form-control" id="assigned_to_id" name="assigned_to_id" :options="$this->listsForFields['engineers']"
                        wire:model="task.assigned_to_id" />
                    <div class="validation-message">
                        {{ $errors->first('task.engineer_id') }}
                    </div>
                    <div class="help-block">
                    </div>
                </div>

                <div class="form-group {{ $errors->has('task.status_id') ? 'invalid' : '' }}">
                    <label class="form-label required" for="status">Choose Status</label>
                    <x-select-list class="form-control" required id="status_id" name="status_id" :options="$this->listsForFields['status']"
                        wire:model="task.status_id" />
                    <div class="validation-message">
                        {{ $errors->first('task.status_id') }}
                    </div>
                    <div class="help-block">
                    </div>
                </div>

                <div class="form-group">
                    <button class="btn btn-indigo mr-2" type="submit">
                        {{ trans('global.save') }}
                    </button>
                    <a wire:click.prevent="cancel" class="btn btn-secondary">
                        {{ trans('global.cancel') }}
                    </a>
                </div>
            </form>
        </section>
    </div>
</div>
