<div>
    <section class="py-6 px-4 text-gray-600 body-font  h-6/5">
        @include('components.loading-spinner-full-page')
        <h2>Products </h2>
        <div class="p-2">

            <ol class="relative border-l border-gray-200 dark:border-gray-700">
                @foreach ($task->taskProductRequestLogs as $evt)
                    <li class="mb-10 ml-6" v-for="(tEvt, index) in taskTimelines">
                        <span
                            class="flex absolute -left-3 justify-center items-center w-6 h-6 bg-blue-200 rounded-full ring-8 ring-white dark:ring-gray-900 dark:bg-blue-900">
                            <svg aria-hidden="true" class="w-3 h-3 text-blue-600 dark:text-blue-400" fill="currentColor"
                                viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </span>
                        <h3 class="mb-1 text-lg font-semibold text-gray-900 ">{{ $evt->event_type_label }}</h3>
                        <time
                            class="block mb-2 text-sm font-normal leading-none text-gray-400 dark:text-gray-500">{{ $evt->created_at }}</time>
                        <p class="text-base font-normal text-gray-500 dark:text-gray-400">{{ $evt->description }}</p>
                        @if ($evt->loggedBy)
                            <time
                                class="block mb-2 text-xs font-normal leading-none text-gray-400 dark:text-gray-500">by
                                {{ $evt->loggedBy->name_role ?? '' }}</time>
                        @endif
                        @if (count($evt->all_products) > 0)
                            @if (false)
                                <div id="{{ $accordion1Id }}-wrapper">
                                    <div id="{{ $accordion1Id }}" data-accordion="collapse">

                                        @foreach ($evt->all_products as $item)
                                            <h2 id="{{ $accordion1Id }}-heading-1">
                                                <button type="button"
                                                    class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                                                    data-accordion-target="#{{ $accordion1Id }}-body-1"
                                                    aria-expanded="true" aria-controls="{{ $accordion1Id }}-body-1">
                                                    <span>What is Flowbite?</span>
                                                    <svg data-accordion-icon class="w-6 h-6 rotate-180 shrink-0"
                                                        fill="currentColor" viewBox="0 0 20 20"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd"
                                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                            clip-rule="evenodd"></path>
                                                    </svg>
                                                </button>
                                            </h2>
                                            <div id="{{ $accordion1Id }}-body-1" class="hidden"
                                                aria-labelledby="{{ $accordion1Id }}-heading-1">
                                                <div
                                                    class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                                                    <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is an
                                                        open-source
                                                        library of
                                                        interactive components built on top of Tailwind CSS including
                                                        buttons,
                                                        dropdowns,
                                                        modals,
                                                        navbars, and more.</p>
                                                    <p class="text-gray-500 dark:text-gray-400">Check out this guide to
                                                        learn how to
                                                        <a href="/docs/getting-started/introduction/"
                                                            class="text-blue-600 dark:text-blue-500 hover:underline">get
                                                            started</a>
                                                        and start
                                                        developing websites even faster with components on top of
                                                        Tailwind
                                                        CSS.
                                                    </p>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            <table class="table table-index w-full">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Qty Requested</th>
                                        <th>Current Qty. (Circle)</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($evt->all_products as $item)
                                        @php
                                            $stockAvailable = $cStock($item->product_id);
                                            $canAccept = $stockAvailable >= $item->quantity;
                                            $needAccept = $stockAvailable >= $item->quantity;
                                            $needQuantity = $item->quantity - $stockAvailable;

                                        @endphp
                                        <tr>
                                            <td class="px-1">
                                                <code before="#"
                                                    class="before:content-[attr(before)]">{{ $item->id }}</code>
                                                {{ $item->product_name }}
                                                @if (!empty($item->product_model))
                                                    <br>Model: {{ $item->product_model }}
                                                @endif
                                            </td>
                                            <td class="px-1">{{ $item->product_description }}</td>
                                            <td class="px-1">{{ $item->quantity }}</td>
                                            <td class="px-1">{{ $stockAvailable }}</td>
                                            <td class="px-1">{{ $item->status_label }}</td>
                                            <td class="px-1">
                                                @if (auth()->user()->isCircleOfficer())
                                                    @if ($canAccept)
                                                        @if ($item->status == 'accepted')
                                                            <span class="text-sm">Product Sent</span>
                                                        @else
                                                            <button type="button" class="btn btn-primary btn-sm"
                                                                wire:click="acceptProductRequest('{{ $item->product_id }}','{{ $item->id }}')">Accept
                                                                And Send</button>
                                                        @endif
                                                    @else
                                                        {{-- <button type="button" class="btn btn-primary btn-sm disabled opacity-75" disabled >Accept And Send</button> --}}
                                                        @if ($item->status == 'requested')
                                                            <span class="text-sm">Already Requested</span>
                                                        @else
                                                            <button type="button" class="btn btn-primary btn-sm"
                                                                wire:click="requestProductToZonal('{{ $item->product_id }}','{{ $needQuantity }}',{{ json_encode($item) }})">Request
                                                                to Zonal Office</button>
                                                        @endif
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>
                                        {{-- <tr>
                                            <td colspan="6" >@dump($item->product, $item->info)</td>
                                        </tr> --}}
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                        {{-- <pre>@json($evt, JSON_PRETTY_PRINT)</pre> --}}
                    </li>
                @endforeach
            </ol>


            <div id="{{ $accordion1Id }}-wrapper" class="hidden">
                <div id="{{ $accordion1Id }}" data-accordion="collapse">
                    <h2 id="{{ $accordion1Id }}-heading-1">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#{{ $accordion1Id }}-body-1" aria-expanded="true"
                            aria-controls="{{ $accordion1Id }}-body-1">
                            <span>What is Flowbite?</span>
                            <svg data-accordion-icon class="w-6 h-6 rotate-180 shrink-0" fill="currentColor"
                                viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="{{ $accordion1Id }}-body-1" class="hidden"
                        aria-labelledby="{{ $accordion1Id }}-heading-1">
                        <div
                            class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is an open-source library of
                                interactive components built on top of Tailwind CSS including buttons, dropdowns,
                                modals,
                                navbars, and more.</p>
                            <p class="text-gray-500 dark:text-gray-400">Check out this guide to learn how to <a
                                    href="/docs/getting-started/introduction/"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">get started</a> and start
                                developing websites even faster with components on top of Tailwind CSS.</p>
                        </div>
                    </div>
                    <h2 id="{{ $accordion1Id }}-heading-2">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#{{ $accordion1Id }}-body-2" aria-expanded="false"
                            aria-controls="{{ $accordion1Id }}-body-2">
                            <span>Is there a Figma file available?</span>
                            <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="{{ $accordion1Id }}-body-2" class="hidden"
                        aria-labelledby="{{ $accordion1Id }}-heading-2">
                        <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is first conceptualized and
                                designed
                                using the Figma software so everything you see in the library has a design equivalent in
                                our
                                Figma file.</p>
                            <p class="text-gray-500 dark:text-gray-400">Check out the <a
                                    href="https://flowbite.com/figma/"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">Figma design system</a>
                                based
                                on the utility classes from Tailwind CSS and components from Flowbite.</p>
                        </div>
                    </div>
                    <h2 id="{{ $accordion1Id }}-heading-3">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#{{ $accordion1Id }}-body-3" aria-expanded="false"
                            aria-controls="{{ $accordion1Id }}-body-3">
                            <span>What are the differences between Flowbite and Tailwind UI?</span>
                            <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="{{ $accordion1Id }}-body-3" class="hidden"
                        aria-labelledby="{{ $accordion1Id }}-heading-3">
                        <div class="p-5 font-light border border-t-0 border-gray-200 dark:border-gray-700">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">The main difference is that the core
                                components
                                from Flowbite are open source under the MIT license, whereas Tailwind UI is a paid
                                product.
                                Another difference is that Flowbite relies on smaller and standalone components, whereas
                                Tailwind UI offers sections of pages.</p>
                            <p class="mb-2 text-gray-500 dark:text-gray-400">However, we actually recommend using both
                                Flowbite, Flowbite Pro, and even Tailwind UI as there is no technical reason stopping
                                you
                                from using the best of two worlds.</p>
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Learn more about these technologies:</p>
                            <ul class="pl-5 text-gray-500 list-disc dark:text-gray-400">
                                <li><a href="https://flowbite.com/pro/"
                                        class="text-blue-600 dark:text-blue-500 hover:underline">Flowbite Pro</a></li>
                                <li><a href="https://tailwindui.com/" rel="nofollow"
                                        class="text-blue-600 dark:text-blue-500 hover:underline">Tailwind UI</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <script>
        // alert(@json(uniqid()));
        window.accordion1 = document.querySelector("#{{ $accordion1Id }}-wrapper");

        window.lwModalInitialized.push({
            call: () => {
                initiateFlowBiteAccordion(document.querySelector("#{{ $accordion1Id }}"));
            },
            calledCount: 0,
            callOnce: false,
            isCalled: false
        });
        // setTimeout(() => {
        //     initiateFlowBiteAccordion(document.querySelector("#{{ $accordion1Id }}"))
        // }, 1000);
    </script>
</div>
