<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('specialPlannedDay.title') ? 'invalid' : '' }}">
        <label class="form-label requiredx" for="title">{{ trans('cruds.specialPlannedDay.fields.title') }}</label>
        <input class="form-control" type="text" name="title" id="title" required wire:model.defer="specialPlannedDay.title">
        <div class="validation-message">
            {{ $errors->first('specialPlannedDay.title') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.specialPlannedDay.fields.title_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('specialPlannedDay.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.specialPlannedDay.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="specialPlannedDay.description" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('specialPlannedDay.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.specialPlannedDay.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('specialPlannedDay.leave_type') ? 'invalid' : '' }}">
        <label class="form-label required">{{ trans('cruds.specialPlannedDay.fields.leave_type') }}</label>
        @foreach($this->listsForFields['leave_type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="leave_type" wire:model="specialPlannedDay.leave_type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('specialPlannedDay.leave_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.specialPlannedDay.fields.leave_type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('specialPlannedDay.from_date') ? 'invalid' : '' }}">
        <label class="form-label required" for="from_date">{{ trans('cruds.specialPlannedDay.fields.from_date') }}</label>
        <x-date-picker class="form-control" required wire:model="specialPlannedDay.from_date" id="from_date" name="from_date" picker="date" />
        <div class="validation-message">
            {{ $errors->first('specialPlannedDay.from_date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.specialPlannedDay.fields.from_date_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('specialPlannedDay.to_date') ? 'invalid' : '' }} hidden ">
        <label class="form-label required" for="to_date">{{ trans('cruds.specialPlannedDay.fields.to_date') }}</label>
        <x-date-picker class="form-control" required wire:model="specialPlannedDay.to_date" id="to_date" name="to_date" picker="date" />
        <div class="validation-message">
            {{ $errors->first('specialPlannedDay.to_date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.specialPlannedDay.fields.to_date_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.special-planned-days.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
