<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')
{{--
    <pre>@json($sett,JSON_PRETTY_PRINT)</pre> --}}
    <div class="grid grid-cols-3 gap-4">

        <div class="form-group {{ $errors->has('sett.basic') ? 'invalid' : '' }}">
            <label class="form-label required" for="basic">Basic</label>
            <input class="form-control" type="number"  step="0.05" name="basic" id="basic" required wire:model.defer="sett.basic">
            <div class="validation-message">
                {{ $errors->first('sett.basic') }}
            </div>
            <div class="help-block">
                Set the percentage of gross for Basic
            </div>
        </div>

        <div class="form-group {{ $errors->has('sett.hra') ? 'invalid' : '' }}">
            <label class="form-label required" for="hra">HRA</label>
            <input class="form-control" type="number"  step="0.05" name="hra" id="hra" required
                wire:model.defer="sett.hra">
            <div class="validation-message">
                {{ $errors->first('sett.hra') }}
            </div>
            <div class="help-block">
                Set the percentage of gross for HRA
            </div>
        </div>

        <div class="form-group {{ $errors->has('sett.conveyance') ? 'invalid' : '' }}">
            <label class="form-label required" for="conveyance">Conveyance Allowance</label>
            <input class="form-control" type="number"  step="0.05" name="conveyance" id="conveyance" required
                wire:model.defer="sett.conveyance">
            <div class="validation-message">
                {{ $errors->first('sett.conveyance') }}
            </div>
            <div class="help-block">
                Set the percentage of gross for Conveyance Allowance
            </div>
        </div>

        <div class="form-group {{ $errors->has('sett.pf') ? 'invalid' : '' }}">
            <label class="form-label required" for="pf">PF</label>
            <input class="form-control" type="number"  step="0.05" name="pf" id="pf" required
                wire:model.defer="sett.pf">
            <div class="validation-message">
                {{ $errors->first('sett.pf') }}
            </div>
            <div class="help-block">
                Set the percentage of Basic for PF
            </div>
        </div>

        <div class="form-group {{ $errors->has('sett.esi') ? 'invalid' : '' }}">
            <label class="form-label required" for="esi">ESI</label>
            <input class="form-control" type="number"  step="0.05" name="esi" id="esi" required
                wire:model.defer="sett.esi">
            <div class="validation-message">
                {{ $errors->first('sett.esi') }}
            </div>
            <div class="help-block">
                Set the percentage of gross for PF
            </div>
        </div>
        <div class="form-group {{ $errors->has('sett.ptax.10k15k') ? 'invalid' : '' }}">
            <label class="form-label required" for="ptax-10k15k">P.Tax (Within 10k - 15k)</label>
            <input class="form-control" type="number"  step="0.05" name="ptax-10k15k" id="ptax-10k15k" required
                wire:model.defer="sett.ptax.10k15k">
            <div class="validation-message">
                {{ $errors->first('sett.ptax.10k15k') }}
            </div>
            <div class="help-block">
                Set the amount of PTax for Gross Within 10k - 15k
            </div>
        </div>
        <div class="form-group {{ $errors->has('sett.ptax.above15k') ? 'invalid' : '' }}">
            <label class="form-label required" for="ptax-above15k">P.Tax (Above 15k)</label>
            <input class="form-control" type="number"  step="0.05" name="ptax-above15k" id="ptax-above15k" required
                wire:model.defer="sett.ptax.above15k">
            <div class="validation-message">
                {{ $errors->first('sett.ptax.above15k') }}
            </div>
            <div class="help-block">
                Set the amount of PTax for Gross more than 15k
            </div>
        </div>
    </div>


    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
