<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')

    <div class="form-group {{ $errors->has('service.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.service.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="service.name">
        <div class="validation-message">
            {{ $errors->first('service.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.service.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('service.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.service.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="service.description" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('service.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.service.fields.description_helper') }}
        </div>
    </div>

    <div class="form-group {{ $errors->has('service.hsn_code') ? 'invalid' : '' }}">
        <label class="form-label required" for="hsn_code">{{ trans('cruds.service.fields.hsn_code') }}</label>
        <input class="form-control" type="text" name="hsn_code" id="hsn_code" required
            wire:model.defer="service.hsn_code">
        <div class="validation-message">
            {{ $errors->first('service.hsn_code') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.service.fields.hsn_code_helper') }}
        </div>
    </div>
    <div class="grid grid-cols-4 gap-2">

        <div class="form-group {{ $errors->has('service.taxable_price') ? 'invalid' : '' }}">
            <label class="form-label required"
                for="taxable_price">{{ trans('cruds.service.fields.taxable_price') }}</label>
            <input class="form-control" type="number" name="taxable_price" id="taxable_price" required
                wire:model.debounce.700ms="service.taxable_price" step="0.01">
            <div class="validation-message">
                {{ $errors->first('service.taxable_price') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.taxable_price_helper') }}
            </div>
        </div>
        <div class="form-group {{ $errors->has('service.gst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="gst_rate">{{ trans('cruds.service.fields.gst_rate') }}</label>
            <input class="form-control" type="number" name="gst_rate" id="gst_rate" required
                wire:model.debounce.700ms="service.gst_rate" step="0.01">
            <div class="validation-message">
                {{ $errors->first('service.gst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.gst_rate_helper') }}
            </div>
        </div>
        <div class="col-span-2">
            &nbsp;
        </div>

        <div class="form-group {{ $errors->has('service.cgst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="cgst_rate">{{ trans('cruds.service.fields.cgst_rate') }}</label>
            <input class="form-control disabled" type="number" name="cgst_rate" id="cgst_rate" required
                wire:model="service.cgst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('service.cgst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.cgst_rate_helper') }}
            </div>
        </div>

        <div class="form-group {{ $errors->has('service.sgst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="sgst_rate">{{ trans('cruds.service.fields.sgst_rate') }}</label>
            <input class="form-control disabled" type="number" name="sgst_rate" id="sgst_rate" required
                wire:model="service.sgst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('service.sgst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.sgst_rate_helper') }}
            </div>
        </div>

        <div class="form-group {{ $errors->has('service.igst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="igst_rate">{{ trans('cruds.service.fields.igst_rate') }}</label>
            <input class="form-control disabled" type="number" name="igst_rate" id="igst_rate" required
                wire:model="service.igst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('service.igst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.igst_rate_helper') }}
            </div>
        </div>
        <div class="form-group {{ $errors->has('service.price') ? 'invalid' : '' }}">
            <label class="form-label required" for="price">{{ trans('cruds.service.fields.price') }}</label>
            <input class="form-control disabled" type="number" name="price" id="price" required
                wire:model.defer="service.price" step="0.01" tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('service.price') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.service.fields.price_helper') }}
            </div>
        </div>
    </div>
    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.services.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
