<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('purchase.suply_invc_no') ? 'invalid' : '' }}">
        <label class="form-label" for="suply_invc_no">{{ trans('cruds.purchase.fields.suply_invc_no') }}</label>
        <input class="form-control" type="text" name="suply_invc_no" id="suply_invc_no" wire:model.defer="purchase.suply_invc_no">
        <div class="validation-message">
            {{ $errors->first('purchase.suply_invc_no') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.suply_invc_no_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.prchs_date') ? 'invalid' : '' }}">
        <label class="form-label" for="prchs_date">{{ trans('cruds.purchase.fields.prchs_date') }}</label>
        <x-date-picker class="form-control" wire:model="purchase.prchs_date" id="prchs_date" name="prchs_date" picker="date" />
        <div class="validation-message">
            {{ $errors->first('purchase.prchs_date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.prchs_date_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.party_ac') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.purchase.fields.party_ac') }}</label>
        <select class="form-control" wire:model="purchase.party_ac">
            <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
            @foreach($this->listsForFields['party_ac'] as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="validation-message">
            {{ $errors->first('purchase.party_ac') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.party_ac_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.total_invoic') ? 'invalid' : '' }}">
        <label class="form-label" for="total_invoic">{{ trans('cruds.purchase.fields.total_invoic') }}</label>
        <input class="form-control" type="number" name="total_invoic" id="total_invoic" wire:model.defer="purchase.total_invoic" step="0.01">
        <div class="validation-message">
            {{ $errors->first('purchase.total_invoic') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.total_invoic_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.csgt_amt') ? 'invalid' : '' }}">
        <label class="form-label" for="csgt_amt">{{ trans('cruds.purchase.fields.csgt_amt') }}</label>
        <input class="form-control" type="number" name="csgt_amt" id="csgt_amt" wire:model.defer="purchase.csgt_amt" step="0.01">
        <div class="validation-message">
            {{ $errors->first('purchase.csgt_amt') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.csgt_amt_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.sgst_amt') ? 'invalid' : '' }}">
        <label class="form-label" for="sgst_amt">{{ trans('cruds.purchase.fields.sgst_amt') }}</label>
        <input class="form-control" type="number" name="sgst_amt" id="sgst_amt" wire:model.defer="purchase.sgst_amt" step="0.01">
        <div class="validation-message">
            {{ $errors->first('purchase.sgst_amt') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.sgst_amt_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.igst_amt') ? 'invalid' : '' }}">
        <label class="form-label" for="igst_amt">{{ trans('cruds.purchase.fields.igst_amt') }}</label>
        <input class="form-control" type="number" name="igst_amt" id="igst_amt" wire:model.defer="purchase.igst_amt" step="0.01">
        <div class="validation-message">
            {{ $errors->first('purchase.igst_amt') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.igst_amt_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.invoice_total_wo_tax') ? 'invalid' : '' }}">
        <label class="form-label" for="invoice_total_wo_tax">{{ trans('cruds.purchase.fields.invoice_total_wo_tax') }}</label>
        <input class="form-control" type="number" name="invoice_total_wo_tax" id="invoice_total_wo_tax" wire:model.defer="purchase.invoice_total_wo_tax" step="0.01">
        <div class="validation-message">
            {{ $errors->first('purchase.invoice_total_wo_tax') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.invoice_total_wo_tax_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('purchase.details') ? 'invalid' : '' }}">
        <label class="form-label" for="details">{{ trans('cruds.purchase.fields.details') }}</label>
        <input class="form-control" type="text" name="details" id="details" wire:model.defer="purchase.details">
        <div class="validation-message">
            {{ $errors->first('purchase.details') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.purchase.fields.details_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.purchases.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>