<form wire:submit.prevent="submit" class="pt-3">

    <div class="container  mx-auto">
        <div class="flex flex-wrap">

            <div class="flex flex-1  flex-col md:flex-row lg:flex-row mx-2">
                <div class="mb-2 border-solid border-gray-300 rounded border shadow-sm w-full">
                    <div class="bg-gray-200 px-2 py-3 border-solid border-gray-200 border-b">
                        New Purchase
                    </div>
                    <div class="p-3">

                        <div class="flex items-center">
                            <div class="item w-1/2 h-32 px-2">
                                <div class="form-group {{ $errors->has('purchase.suply_invc_no') ? 'invalid' : '' }}">
                                <label class="form-label" for="suply_invc_no">{{ trans('cruds.purchase.fields.suply_invc_no') }}</label>
                                <input class="form-control" type="text" name="suply_invc_no" id="suply_invc_no" wire:model.defer="purchase.suply_invc_no">
                                <div class="validation-message">
                                    {{ $errors->first('purchase.suply_invc_no') }}
                                </div>
                                <div class="help-block">
                                    {{ trans('cruds.purchase.fields.suply_invc_no_helper') }}
                                </div>
                            </div>
                            <div class="form-group {{ $errors->has('purchase.party_ac') ? 'invalid' : '' }}">
                                <label class="form-label">{{ trans('cruds.purchase.fields.party_ac') }}</label>
                                {{-- <select class="form-control" wire:model="purchase.party_ac">
                                    <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
                                    @foreach($this->listsForFields['party_ac'] as $key => $value)
                                        <option value="{{ $key }}">{{ $value }}</option>
                                    @endforeach
                                </select> --}}
                                <x-select-list class="form-control" required id="ledger_group" name="ledger_group" :options="$this->listsForFields['ledger_group']" wire:model="ledger.ledger_group_id"  />

                                {{-- <div class="validation-message">
                                    {{ $errors->first('purchase.party_ac') }}
                                </div> --}}
                                {{-- <div class="help-block">
                                    {{ trans('cruds.purchase.fields.party_ac_helper') }}
                                </div> --}}
                            </div>

                        </div>
                            <div class="item w-1/2 h-32 px-2">
                                <div class="form-group {{ $errors->has('purchase.prchs_date') ? 'invalid' : '' }}">
                                    <label class="form-label" for="prchs_date">{{ trans('cruds.purchase.fields.prchs_date') }}</label>
                                    <x-date-picker class="form-control" wire:model="purchase.prchs_date" id="prchs_date" name="prchs_date" picker="date" />
                                    <div class="validation-message">
                                        {{ $errors->first('purchase.prchs_date') }}
                                    </div>
                                    <div class="help-block">
                                        {{ trans('cruds.purchase.fields.prchs_date_helper') }}
                                    </div>
                                </div>
                            </div>
                        </div>







                    </div>
                </div>
            </div>

















          {{-- <div class="w-full"></div>
          <div class="w-full px-4 flex-1">
            <span class="text-sm block my-4 p-3 text-blueGray-700 rounded border border-solid border-blueGray-100">column</span>
          </div>
          <div class="w-full px-4 flex-1">
            <span class="text-sm block my-4 p-3 text-blueGray-700 rounded border border-solid border-blueGray-100">column</span>
          </div> --}}
        </div>
      </div>




      <div class="flex flex-1  flex-col md:flex-row lg:flex-row mx-2">
        <div class="mb-2 border-solid border-gray-300 rounded border shadow-sm w-full">
            <div class="bg-gray-200 px-2 py-3 border-solid border-gray-200 border-b">
                Items
            </div>
            <div class="p-3">
                <div class="container px-4 mx-auto">
                    <div class="flex flex-wrap">
                      <div class="w-full px-4 flex-1">
                        {{-- <div class="form-group {{ $errors->has('purchase.total_invoic') ? 'invalid' : '' }}">
                            <label class="form-label" for="total_invoic">{{ trans('cruds.purchase.fields.total_invoic') }}</label>
                            <input class="form-control" type="number" name="total_invoic" id="total_invoic" wire:model.defer="purchase.total_invoic" step="0.01">
                            <div class="validation-message">
                                {{ $errors->first('purchase.total_invoic') }}
                            </div>
                            <div class="help-block">
                                {{ trans('cruds.purchase.fields.total_invoic_helper') }}
                            </div>
                        </div> --}}

                        {{-- @livewire('purchase.create.product-search') --}}
                        {{-- <livewire:purchase.create.product-search /> --}}
                        <div class="p-3">
                            <div class="relative">
                                        <div class="flex items-center border-b border-b-1 border-teal-500 py-2">
                                            <input wire:model.debounce.800ms="srhItem" wire:keydown.escape="resetall()"  wire:keydown.tab="resetall()"  class="appearance-none  border-none w-full text-gray-600 mr-3 py-1 px-2 lineHeight-tight focus:outline-none" type="text" placeholder="Search Product" aria-label="Search Product">

                                            <button wire:click="resetall()"  class="flex-shrink-0 btn btn-indigo mr-2 border-4 text-teal hover:text-teal-darker text-sm py-1 px-2 rounded" type="button">
                                                Add Item
                                            </button>
                                        </div>
                                        @if (isset($items))
                                        <div class=" absolute z-10 line-group bg-white  w-full shadow-lg rounded-t-none">

                                        <ul class="divide-y divide-gray-100">
                                            @foreach ($items as $item )
                                            {{-- <a href="">{{$item['name']}}</a> --}}

                                            <li class="p-3 hover:bg-blue-600 hover:text-blue-200" >
                                                <a wire:click="addItemClickEvt('{{$item->id}}')"  class="list-item">{{$item->name}}</a>
                                                {{-- {{$item->name}} deltItemClickEvt($id)--}}
                                            </li>
                                        @endforeach

                                        </ul>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            {{-- {{$invItems}} --}}

                            <table class="table-responsive w-full rounded" class="shipToFrom">
                                <thead>
                                  <tr>
                                    <th class="border w-1/4 px-4 py-2">Item</th>
                                    <th class="border w-1/6 px-4 py-2">Quantity</th>
                                    <th class="border w-1/6 px-4 py-2">Price (₹)</th>
                                    {{-- <th class="border w-1/6 px-4 py-2">Tax (%)</th> --}}
                                    <th class="border w-1/7 px-4 py-2">Amount (₹)</th>
                                    <th class="border w-1/5 px-4 py-2 docEdit trAdd" ></th>

                                  </tr>
                                </thead>
                                <tbody>
                                    @if (isset($invItems))
                            @foreach ($invItems as $invitem )
                            {{-- <a href="">{{$item['name']}}</a> --}}


                                {{-- {{$invitem['name']}} --}}
                                {{-- {{$item->name}} --}}
                                <tr>
                                    <td class="border px-4 py-2">{{$invitem['name']}}</td>
                                    <td class="border px-4 py-2"><input id="trm_q_{{$invitem['id']}}" wire:model="addeditem.{{$invitem['id']}}.qnty" name="trm_q_{{$invitem['id']}}" value="{{$invitem['qnty']}}" class="appearance-none block w-full bg-gray-200 text-gray-700 border border-gray-200 rounded py-3 px-2 leading-tight focus:outline-none focus:bg-white focus:border-gray-500"  type="text" placeholder="Qnt">
                                        </td>
                                    <td class="border px-4 py-2 text-center">{{$invitem['price']}}</td>
                                    {{-- <td class="border px-4 py-2">900 $</td> --}}
                                    <td class="border px-4 py-2 text-center">
                                        {{-- <i class="fas fa-check text-green-500 mx-2"></i> --}}

                                        {{$invitem['total']}}
                                    </td>
                                    <td class="border px-4 py-2">
                                        {{-- <a class="bg-teal-300 cursor-pointer rounded p-1 mx-1 text-white">
                                                <i class="fas fa-eye"></i></a>
                                        <a class="bg-teal-300 cursor-pointer rounded p-1 mx-1 text-white">
                                                <i class="fas fa-edit"></i></a> --}}
                                        <a wire:click="deltItemClickEvt('{{$invitem['id']}}')" class="bg-teal-300 cursor-pointer rounded p-1 mx-1 text-red-500">
                                                <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>

                            @endforeach

                            {{-- <pre>@json($invItems,JSON_PRETTY_PRINT)</pre>
                            <pre>@json($addeditem,JSON_PRETTY_PRINT)</pre> --}}
                            @endif

                                </tbody>

                                <tfoot>
                                    @if (isset($taxledgers) && count($addeditem)>0)


                                    {{-- @foreach ($addtax as $adtx ) --}}
                                    @foreach ($addtax as $taxindex => $adtx )

                                    <tr>
                                        <th colspan="3" style="text-align: right">

                                            <select id="tx-{{uniqid()}}" class=" form-control " wire:model="addtax.{{$taxindex}}.ledger_id">
                                                <option value="-1">--Select Tax--</option>
                                                @foreach ($taxledgers as $txledger )
                                                {{-- <option selected>Choose {{$attributes->title}}</option>
                                                @foreach ($attributes->ledgerattrvalues as $attributevalue)
                                                <option value="{{$attributevalue->id}}">{{$attributevalue->value}}</option>
                                                @endforeach --}}

                                                <option value="{{$txledger->id}}">{{$txledger->name}}</option>
                                                @endforeach

                                              </select>
                                        </th>
                                        <td class="border px-4 py-2 text-center">
                                            {{$addtax[$taxindex]['amont']}}
                                            {{-- <input id="txmnt-{{uniqid()}}"  name="trm_q_11" value="" class="appearance-none block w-full bg-gray-200 text-gray-700 border border-gray-200 rounded py-3 px-2 leading-tight focus:outline-none focus:bg-white focus:border-gray-500"  type="text" placeholder="amt"> --}}
                                        </td>
                                    <td class="border px-4 py-2"> <a  class="bg-teal-300 cursor-pointer rounded p-1 mx-1 text-red-500">
                                        <i class="fas fa-trash"></i></td>
                                    </tr>
                                    @endforeach




                                    @endif
                                    @if (count($addeditem)>0)
                                    <tr>
                                        <th colspan="3" style="text-align: right">
                                            Tax

                                        </th>
                                        <td style="text-align: center"><a wire:click="addtaxClickEvt()"><i class="fa fa-plus-circle" aria-hidden="true"></i></a></td>
                                    <td></td>
                                    </tr>
                                    @endif

                                </tfoot>
                            </table>

                           <pre>@json($distnttaxrate,JSON_PRETTY_PRINT)</pre>
                            {{--  <pre>@json($taxledgers,JSON_PRETTY_PRINT)</pre> --}}
                            {{-- <pre>@json($invItems,JSON_PRETTY_PRINT)</pre> --}}
                            <pre>@json($addtax,JSON_PRETTY_PRINT)</pre>

                      </div>


                    </div>
                  </div>


                  {{-- <div class="document active">
                    <div class="spreadSheetGroup"> --}}

                    {{-- </div>
                  </div> --}}
            </div>
        </div>
    </div>



    <div class="flex">
        <div class="item w-1/2 h-32">
            <div class="mb-2 border-solid border-grey-light rounded border shadow-sm w-full md:w-1/2 lg:w-1/2">
                <div class="bg-gray-300 px-2 py-3 border-solid border-gray-400 border-b">
                    Details
                </div>
                <div class="p-3">
                    <div class="form-group {{ $errors->has('purchase.details') ? 'invalid' : '' }}">
                        <label class="form-label" for="details">{{ trans('cruds.purchase.fields.details') }}</label>
                        <input class="form-control" type="text" name="details" id="details" wire:model.defer="purchase.details">
                        <div class="validation-message">
                            {{ $errors->first('purchase.details') }}
                        </div>
                        <div class="help-block">
                            {{ trans('cruds.purchase.fields.details_helper') }}
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="item w-1/2 h-32 px-2">
            <div class="form-group {{ $errors->has('purchase.total_invoic') ? 'invalid' : '' }}">
                <label class="form-label" for="total_invoic">{{ trans('cruds.purchase.fields.total_invoic') }}</label>
                <input class="form-control" value="{{$subtotal}}" type="number" name="total_invoic" id="total_invoic" xx--wire:model.defer="purchase.total_invoic" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('purchase.total_invoic') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.purchase.fields.total_invoic_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('purchase.csgt_amt') ? 'invalid' : '' }}">
                <label class="form-label" for="csgt_amt">{{ trans('cruds.purchase.fields.csgt_amt') }}</label>
                <input class="form-control" type="number" name="csgt_amt" id="csgt_amt" wire:model.defer="purchase.csgt_amt" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('purchase.csgt_amt') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.purchase.fields.csgt_amt_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('purchase.sgst_amt') ? 'invalid' : '' }}">
                <label class="form-label" for="sgst_amt">{{ trans('cruds.purchase.fields.sgst_amt') }}</label>
                <input class="form-control" type="number" name="sgst_amt" id="sgst_amt" wire:model.defer="purchase.sgst_amt" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('purchase.sgst_amt') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.purchase.fields.sgst_amt_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('purchase.igst_amt') ? 'invalid' : '' }}">
                <label class="form-label" for="igst_amt">{{ trans('cruds.purchase.fields.igst_amt') }}</label>
                <input class="form-control" type="number" name="igst_amt" id="igst_amt" wire:model.defer="purchase.igst_amt" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('purchase.igst_amt') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.purchase.fields.igst_amt_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('purchase.invoice_total_wo_tax') ? 'invalid' : '' }}">
                <label class="form-label" for="invoice_total_wo_tax">{{ trans('cruds.purchase.fields.invoice_total_wo_tax') }}</label>
                <input class="form-control" type="number" name="invoice_total_wo_tax" id="invoice_total_wo_tax" wire:model.defer="purchase.invoice_total_wo_tax" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('purchase.invoice_total_wo_tax') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.purchase.fields.invoice_total_wo_tax_helper') }}
                </div>
            </div>
        </div>
    </div>


    <div class="flex items-center">
        <div class="item w-full h-32">

            <div class="form-group">
                <button class="btn btn-indigo mr-2" type="submit">
                    {{ trans('global.save') }}
                </button>
                <a href="{{ route('admin.purchases.index') }}" class="btn btn-secondary">
                    {{ trans('global.cancel') }}
                </a>
            </div>
        </div>
    </div>






</form>
