<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')

    <div class="form-group {{ $errors->has('product.name') ? 'invalid' : '' }}">
        <label class="form-label required" for="name">{{ trans('cruds.product.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" required wire:model.defer="product.name">
        <div class="validation-message">
            {{ $errors->first('product.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('product.sku') ? 'invalid' : '' }}">
        <label class="form-label required" for="sku">{{ trans('cruds.product.fields.sku') }}</label>
        <input class="form-control" type="text" name="sku" id="sku" required wire:model.debounce.600ms="product.sku">
        <div class="validation-message">
            {{ $errors->first('product.sku') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.sku_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('product.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.product.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="product.description"
            rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('product.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('category') ? 'invalid' : '' }}">
        <label class="form-label" for="category">{{ trans('cruds.product.fields.category') }}</label>
        <x-select-list class="form-control" id="category" name="category" wire:model="category" :options="$this->listsForFields['category']"
            multiple />
        <div class="validation-message">
            {{ $errors->first('category') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.category_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('tag') ? 'invalid' : '' }}">
        <label class="form-label" for="tag">{{ trans('cruds.product.fields.tag') }}</label>
        <x-select-list class="form-control" id="tag" name="tag" wire:model="tag" :options="$this->listsForFields['tag']" multiple />
        <div class="validation-message">
            {{ $errors->first('tag') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.tag_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('mediaCollections.product_photo') ? 'invalid' : '' }}">
        <label class="form-label" for="photo">{{ trans('cruds.product.fields.photo') }}</label>
        <x-dropzone id="photo" name="photo" action="{{ route('admin.products.storeMedia') }}"
            collection-name="product_photo" max-file-size="2" max-width="4096" max-height="4096" max-files="1" />
        <div class="validation-message">
            {{ $errors->first('mediaCollections.product_photo') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.photo_helper') }}
        </div>
    </div>

    <div class="form-group {{ $errors->has('product.hsn_code') ? 'invalid' : '' }}">
        <label class="form-label required" for="hsn_code">{{ trans('cruds.product.fields.hsn_code') }}</label>
        <input class="form-control" type="text" name="hsn_code" id="hsn_code" required
            wire:model.defer="product.hsn_code">
        <div class="validation-message">
            {{ $errors->first('product.hsn_code') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.product.fields.hsn_code_helper') }}
        </div>
    </div>
    <div class="grid grid-cols-4 gap-2">

        <div class="form-group {{ $errors->has('product.taxable_price') ? 'invalid' : '' }}">
            <label class="form-label required"
                for="taxable_price">{{ trans('cruds.product.fields.taxable_price') }}</label>
            <input class="form-control" type="number" name="taxable_price" id="taxable_price" required
                wire:model.debounce.700ms="product.taxable_price" step="0.01">
            <div class="validation-message">
                {{ $errors->first('product.taxable_price') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.taxable_price_helper') }}
            </div>
        </div>
        <div class="form-group {{ $errors->has('product.gst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="gst_rate">{{ trans('cruds.product.fields.gst_rate') }}</label>
            <input class="form-control" type="number" name="gst_rate" id="gst_rate" required
                wire:model.debounce.700ms="product.gst_rate" step="0.01">
            <div class="validation-message">
                {{ $errors->first('product.gst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.gst_rate_helper') }}
            </div>
        </div>
        <div class="col-span-2">
            &nbsp;
        </div>

        <div class="form-group {{ $errors->has('product.cgst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="cgst_rate">{{ trans('cruds.product.fields.cgst_rate') }}</label>
            <input class="form-control disabled" type="number" name="cgst_rate" id="cgst_rate" required
                wire:model="product.cgst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('product.cgst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.cgst_rate_helper') }}
            </div>
        </div>

        <div class="form-group {{ $errors->has('product.sgst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="sgst_rate">{{ trans('cruds.product.fields.sgst_rate') }}</label>
            <input class="form-control disabled" type="number" name="sgst_rate" id="sgst_rate" required
                wire:model="product.sgst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('product.sgst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.sgst_rate_helper') }}
            </div>
        </div>

        <div class="form-group {{ $errors->has('product.igst_rate') ? 'invalid' : '' }}">
            <label class="form-label required" for="igst_rate">{{ trans('cruds.product.fields.igst_rate') }}</label>
            <input class="form-control disabled" type="number" name="igst_rate" id="igst_rate" required
                wire:model="product.igst_rate" step="0.01" readonly tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('product.igst_rate') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.igst_rate_helper') }}
            </div>
        </div>
        <div class="form-group {{ $errors->has('product.price') ? 'invalid' : '' }}">
            <label class="form-label required" for="price">{{ trans('cruds.product.fields.price') }}</label>
            <input class="form-control disabled" type="number" name="price" id="price" required
                wire:model.defer="product.price" step="0.01" tabindex="-1">
            <div class="validation-message">
                {{ $errors->first('product.price') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.product.fields.price_helper') }}
            </div>
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
