<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('product_zone_pivot_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="ProductZonePivot" format="csv" />
                <livewire:excel-export model="ProductZonePivot" format="xlsx" />
                <livewire:excel-export model="ProductZonePivot" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.productZonePivot.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.productZonePivot.fields.product') }}
                            @include('components.table.sort', ['field' => 'product.name'])
                        </th>
                        <th>
                            {{ trans('cruds.product.fields.price') }}
                            @include('components.table.sort', ['field' => 'product.price'])
                        </th>
                        <th>
                            {{ trans('cruds.productZonePivot.fields.zone') }}
                            @include('components.table.sort', ['field' => 'zone.name'])
                        </th>
                        <th>
                            {{ trans('cruds.productZonePivot.fields.quantity') }}
                            @include('components.table.sort', ['field' => 'quantity'])
                        </th>
                        <th>
                            {{ trans('cruds.productZonePivot.fields.price') }}
                            @include('components.table.sort', ['field' => 'price'])
                        </th>
                        <th>
                            {{ trans('cruds.productZonePivot.fields.last_updated_by') }}
                            @include('components.table.sort', ['field' => 'last_updated_by.name'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productZonePivots as $productZonePivot)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $productZonePivot->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $productZonePivot->id }}
                            </td>
                            <td>
                                @if($productZonePivot->product)
                                    <span class="badge badge-relationship">{{ $productZonePivot->product->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($productZonePivot->product)
                                    {{ $productZonePivot->product->price ?? '' }}
                                @endif
                            </td>
                            <td>
                                @if($productZonePivot->zone)
                                    <span class="badge badge-relationship">{{ $productZonePivot->zone->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $productZonePivot->quantity }}
                            </td>
                            <td>
                                {{ $productZonePivot->price }}
                            </td>
                            <td>
                                @if($productZonePivot->lastUpdatedBy)
                                    <span class="badge badge-relationship">{{ $productZonePivot->lastUpdatedBy->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('product_zone_pivot_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.product-zone-pivots.show', $productZonePivot) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('product_zone_pivot_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.product-zone-pivots.edit', $productZonePivot) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('product_zone_pivot_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $productZonePivot->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $productZonePivots->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush