<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('product_task_event_log_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="ProductTaskEventLog" format="csv" />
                <livewire:excel-export model="ProductTaskEventLog" format="xlsx" />
                <livewire:excel-export model="ProductTaskEventLog" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.productTaskEventLog.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.task_event_log') }}
                            @include('components.table.sort', ['field' => 'task_event_log.event_type'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.product') }}
                            @include('components.table.sort', ['field' => 'product.name'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.quantity') }}
                            @include('components.table.sort', ['field' => 'quantity'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.status') }}
                            @include('components.table.sort', ['field' => 'status'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.approved_by') }}
                            @include('components.table.sort', ['field' => 'approved_by.name'])
                        </th>
                        <th>
                            {{ trans('cruds.productTaskEventLog.fields.approved_at') }}
                            @include('components.table.sort', ['field' => 'approved_at'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productTaskEventLogs as $productTaskEventLog)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $productTaskEventLog->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $productTaskEventLog->id }}
                            </td>
                            <td>
                                @if($productTaskEventLog->taskEventLog)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->taskEventLog->event_type ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($productTaskEventLog->product)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->product->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $productTaskEventLog->quantity }}
                            </td>
                            <td>
                                {{ $productTaskEventLog->status_label }}
                            </td>
                            <td>
                                @if($productTaskEventLog->approvedBy)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->approvedBy->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $productTaskEventLog->approved_at }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('product_task_event_log_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.product-task-event-logs.show', $productTaskEventLog) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('product_task_event_log_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.product-task-event-logs.edit', $productTaskEventLog) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('product_task_event_log_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $productTaskEventLog->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $productTaskEventLogs->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush