<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('monthly_payslip_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="MonthlyPayslip" format="csv" />
                <livewire:excel-export model="MonthlyPayslip" format="xlsx" />
                <livewire:excel-export model="MonthlyPayslip" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.monthlyPayslip.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.fin_yr') }}
                            @include('components.table.sort', ['field' => 'fin_yr.title'])
                        </th>
                        <th>
                            {{ trans('cruds.finYr.fields.alias') }}
                            @include('components.table.sort', ['field' => 'fin_yr.alias'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.year') }}
                            @include('components.table.sort', ['field' => 'year'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.month') }}
                            @include('components.table.sort', ['field' => 'month'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.user') }}
                            @include('components.table.sort', ['field' => 'user.name'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.emp_code') }}
                            @include('components.table.sort', ['field' => 'emp_code'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.location') }}
                            @include('components.table.sort', ['field' => 'location'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.payment_mode') }}
                            @include('components.table.sort', ['field' => 'payment_mode'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.bank') }}
                            @include('components.table.sort', ['field' => 'bank'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.bank_ac_no') }}
                            @include('components.table.sort', ['field' => 'bank_ac_no'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.aadhaar') }}
                            @include('components.table.sort', ['field' => 'aadhaar'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.blood_group') }}
                            @include('components.table.sort', ['field' => 'blood_group'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.days_in_month') }}
                            @include('components.table.sort', ['field' => 'days_in_month'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.lwp_days') }}
                            @include('components.table.sort', ['field' => 'lwp_days'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.working_days') }}
                            @include('components.table.sort', ['field' => 'working_days'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.esic_no') }}
                            @include('components.table.sort', ['field' => 'esic_no'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.uan') }}
                            @include('components.table.sort', ['field' => 'uan'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.basic_salary') }}
                            @include('components.table.sort', ['field' => 'basic_salary'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.hra') }}
                            @include('components.table.sort', ['field' => 'hra'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.ta') }}
                            @include('components.table.sort', ['field' => 'ta'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.incentive') }}
                            @include('components.table.sort', ['field' => 'incentive'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.total_earning') }}
                            @include('components.table.sort', ['field' => 'total_earning'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.pf') }}
                            @include('components.table.sort', ['field' => 'pf'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.ptax') }}
                            @include('components.table.sort', ['field' => 'ptax'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.esic') }}
                            @include('components.table.sort', ['field' => 'esic'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.total_deduction') }}
                            @include('components.table.sort', ['field' => 'total_deduction'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.total_payment') }}
                            @include('components.table.sort', ['field' => 'total_payment'])
                        </th>
                        <th>
                            {{ trans('cruds.monthlyPayslip.fields.payment_status') }}
                            @include('components.table.sort', ['field' => 'payment_status'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($monthlyPayslips as $monthlyPayslip)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $monthlyPayslip->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $monthlyPayslip->id }}
                            </td>
                            <td>
                                @if($monthlyPayslip->finYr)
                                    <span class="badge badge-relationship">{{ $monthlyPayslip->finYr->title ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($monthlyPayslip->finYr)
                                    {{ $monthlyPayslip->finYr->alias ?? '' }}
                                @endif
                            </td>
                            <td>
                                {{ $monthlyPayslip->year_label }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->month_label }}
                            </td>
                            <td>
                                @if($monthlyPayslip->user)
                                    <span class="badge badge-relationship">{{ $monthlyPayslip->user->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $monthlyPayslip->emp_code }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->location }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->name }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->payment_mode }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->bank }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->bank_ac_no }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->aadhaar }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->blood_group }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->days_in_month }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->lwp_days }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->working_days }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->esic_no }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->uan }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->basic_salary }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->hra }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->ta }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->incentive }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->total_earning }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->pf }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->ptax }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->esic }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->total_deduction }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->total_payment }}
                            </td>
                            <td>
                                {{ $monthlyPayslip->payment_status_label }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('monthly_payslip_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.monthly-payslips.show', $monthlyPayslip) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('monthly_payslip_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.monthly-payslips.edit', $monthlyPayslip) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('monthly_payslip_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $monthlyPayslip->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $monthlyPayslips->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush