<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('lgAttribute.title') ? 'invalid' : '' }}">
        <label class="form-label required" for="title">{{ trans('cruds.lgAttribute.fields.title') }}</label>
        <input class="form-control" type="text" name="title" id="title" required wire:model.defer="lgAttribute.title">
        <div class="validation-message">
            {{ $errors->first('lgAttribute.title') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttribute.fields.title_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttribute.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.lgAttribute.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="lgAttribute.description" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('lgAttribute.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttribute.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttribute.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="lgAttribute.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.lgAttribute.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('lgAttribute.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttribute.fields.is_active_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttribute.type') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.lgAttribute.fields.type') }}</label>
        @foreach($this->listsForFields['type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="type" wire:model="lgAttribute.type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('lgAttribute.type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttribute.fields.type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttribute.ledger_group_id') ? 'invalid' : '' }}">
        <label class="form-label" for="ledger_group">{{ trans('cruds.lgAttribute.fields.ledger_group') }}</label>
        <x-select-list class="form-control" id="ledger_group" name="ledger_group" :options="$this->listsForFields['ledger_group']" wire:model="lgAttribute.ledger_group_id" />
        <div class="validation-message">
            {{ $errors->first('lgAttribute.ledger_group_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttribute.fields.ledger_group_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.lg-attributes.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>