<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('employee_info_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="EmployeeInfo" format="csv" />
                <livewire:excel-export model="EmployeeInfo" format="xlsx" />
                <livewire:excel-export model="EmployeeInfo" format="pdf" />
            @endif


            @can('employee_info_create')
                <x-csv-import route="{{ route('admin.employee-infos.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.employeeInfo.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.user') }}
                            @include('components.table.sort', ['field' => 'user.name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.first_name') }}
                            @include('components.table.sort', ['field' => 'first_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.middle_name') }}
                            @include('components.table.sort', ['field' => 'middle_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.last_name') }}
                            @include('components.table.sort', ['field' => 'last_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.gender') }}
                            @include('components.table.sort', ['field' => 'gender'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.dob') }}
                            @include('components.table.sort', ['field' => 'dob'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.citizenship') }}
                            @include('components.table.sort', ['field' => 'citizenship'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.age') }}
                            @include('components.table.sort', ['field' => 'age'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.religion') }}
                            @include('components.table.sort', ['field' => 'religion'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.maritial_status') }}
                            @include('components.table.sort', ['field' => 'maritial_status'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.blood_group') }}
                            @include('components.table.sort', ['field' => 'blood_group'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.email') }}
                            @include('components.table.sort', ['field' => 'email'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_line_1') }}
                            @include('components.table.sort', ['field' => 'present_address_line_1'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_line_2') }}
                            @include('components.table.sort', ['field' => 'present_address_line_2'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_line_3') }}
                            @include('components.table.sort', ['field' => 'present_address_line_3'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_line_4') }}
                            @include('components.table.sort', ['field' => 'present_address_line_4'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_district') }}
                            @include('components.table.sort', ['field' => 'present_address_district'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_pin') }}
                            @include('components.table.sort', ['field' => 'present_address_pin'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_state') }}
                            @include('components.table.sort', ['field' => 'present_address_state'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_address_landmark') }}
                            @include('components.table.sort', ['field' => 'present_address_landmark'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_line_1') }}
                            @include('components.table.sort', ['field' => 'permanent_address_line_1'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_line_2') }}
                            @include('components.table.sort', ['field' => 'permanent_address_line_2'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_line_3') }}
                            @include('components.table.sort', ['field' => 'permanent_address_line_3'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_line_4') }}
                            @include('components.table.sort', ['field' => 'permanent_address_line_4'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_district') }}
                            @include('components.table.sort', ['field' => 'permanent_address_district'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_pin') }}
                            @include('components.table.sort', ['field' => 'permanent_address_pin'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_state') }}
                            @include('components.table.sort', ['field' => 'permanent_address_state'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_address_landmark') }}
                            @include('components.table.sort', ['field' => 'permanent_address_landmark'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.personal_phone') }}
                            @include('components.table.sort', ['field' => 'personal_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.present_residence_phone') }}
                            @include('components.table.sort', ['field' => 'present_residence_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.permanent_residence_phone') }}
                            @include('components.table.sort', ['field' => 'permanent_residence_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_name') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_1_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_relation') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_1_relation'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_phone') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_1_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_name') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_2_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_relation') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_2_relation'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_phone') }}
                            @include('components.table.sort', ['field' => 'emergency_contact_2_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.doj') }}
                            @include('components.table.sort', ['field' => 'doj'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.department') }}
                            @include('components.table.sort', ['field' => 'department'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.job_desgination') }}
                            @include('components.table.sort', ['field' => 'job_desgination.title'])
                        </th>
                        <th>
                            {{ trans('cruds.jobDesignation.fields.basic_salary') }}
                            @include('components.table.sort', ['field' => 'job_desgination.basic_salary'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.esic') }}
                            @include('components.table.sort', ['field' => 'esic'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.uan') }}
                            @include('components.table.sort', ['field' => 'uan'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.aadhaar') }}
                            @include('components.table.sort', ['field' => 'aadhaar'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.salary_ac_no') }}
                            @include('components.table.sort', ['field' => 'salary_ac_no'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.salary_ac_bank') }}
                            @include('components.table.sort', ['field' => 'salary_ac_bank'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.salary_ac_ifsc') }}
                            @include('components.table.sort', ['field' => 'salary_ac_ifsc'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.pm_basic_salary') }}
                            @include('components.table.sort', ['field' => 'pm_basic_salary'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.pm_hra') }}
                            @include('components.table.sort', ['field' => 'pm_hra'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.pm_pf') }}
                            @include('components.table.sort', ['field' => 'pm_pf'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.pm_esic') }}
                            @include('components.table.sort', ['field' => 'pm_esic'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeInfo.fields.pm_ptax') }}
                            @include('components.table.sort', ['field' => 'pm_ptax'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employeeInfos as $employeeInfo)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $employeeInfo->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $employeeInfo->id }}
                            </td>
                            <td>
                                @if($employeeInfo->user)
                                    <span class="badge badge-relationship">{{ $employeeInfo->user->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $employeeInfo->first_name }}
                            </td>
                            <td>
                                {{ $employeeInfo->middle_name }}
                            </td>
                            <td>
                                {{ $employeeInfo->last_name }}
                            </td>
                            <td>
                                {{ $employeeInfo->gender_label }}
                            </td>
                            <td>
                                {{ $employeeInfo->dob }}
                            </td>
                            <td>
                                {{ $employeeInfo->citizenship }}
                            </td>
                            <td>
                                {{ $employeeInfo->age }}
                            </td>
                            <td>
                                {{ $employeeInfo->religion }}
                            </td>
                            <td>
                                {{ $employeeInfo->maritial_status_label }}
                            </td>
                            <td>
                                {{ $employeeInfo->blood_group }}
                            </td>
                            <td>
                                <a class="link-light-blue" href="mailto:{{ $employeeInfo->email }}">
                                    <i class="far fa-envelope fa-fw">
                                    </i>
                                    {{ $employeeInfo->email }}
                                </a>
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_line_1 }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_line_2 }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_line_3 }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_line_4 }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_district }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_pin }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_state }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_address_landmark }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_line_1 }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_line_2 }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_line_3 }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_line_4 }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_district }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_pin }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_state }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_address_landmark }}
                            </td>
                            <td>
                                {{ $employeeInfo->personal_phone }}
                            </td>
                            <td>
                                {{ $employeeInfo->present_residence_phone }}
                            </td>
                            <td>
                                {{ $employeeInfo->permanent_residence_phone }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_name }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_relation }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_1_phone }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_name }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_relation }}
                            </td>
                            <td>
                                {{ $employeeInfo->emergency_contact_2_phone }}
                            </td>
                            <td>
                                {{ $employeeInfo->doj }}
                            </td>
                            <td>
                                {{ $employeeInfo->department }}
                            </td>
                            <td>
                                @if($employeeInfo->jobDesgination)
                                    <span class="badge badge-relationship">{{ $employeeInfo->jobDesgination->title ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($employeeInfo->jobDesgination)
                                    {{ $employeeInfo->jobDesgination->basic_salary ?? '' }}
                                @endif
                            </td>
                            <td>
                                {{ $employeeInfo->esic }}
                            </td>
                            <td>
                                {{ $employeeInfo->uan }}
                            </td>
                            <td>
                                {{ $employeeInfo->aadhaar }}
                            </td>
                            <td>
                                {{ $employeeInfo->salary_ac_no }}
                            </td>
                            <td>
                                {{ $employeeInfo->salary_ac_bank }}
                            </td>
                            <td>
                                {{ $employeeInfo->salary_ac_ifsc }}
                            </td>
                            <td>
                                {{ $employeeInfo->pm_basic_salary }}
                            </td>
                            <td>
                                {{ $employeeInfo->pm_hra }}
                            </td>
                            <td>
                                {{ $employeeInfo->pm_pf }}
                            </td>
                            <td>
                                {{ $employeeInfo->pm_esic }}
                            </td>
                            <td>
                                {{ $employeeInfo->pm_ptax }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('employee_info_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.employee-infos.show', $employeeInfo) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('employee_info_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.employee-infos.edit', $employeeInfo) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('employee_info_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $employeeInfo->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $employeeInfos->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush