<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('employee_family_detail_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="EmployeeFamilyDetail" format="csv" />
                <livewire:excel-export model="EmployeeFamilyDetail" format="xlsx" />
                <livewire:excel-export model="EmployeeFamilyDetail" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.employeeFamilyDetail.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.employee_info') }}
                            @include('components.table.sort', ['field' => 'employee_info.first_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.relation') }}
                            @include('components.table.sort', ['field' => 'relation'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.is_dependent') }}
                            @include('components.table.sort', ['field' => 'is_dependent'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.profession') }}
                            @include('components.table.sort', ['field' => 'profession'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.office_name_address') }}
                            @include('components.table.sort', ['field' => 'office_name_address'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeFamilyDetail.fields.office_contact') }}
                            @include('components.table.sort', ['field' => 'office_contact'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employeeFamilyDetails as $employeeFamilyDetail)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $employeeFamilyDetail->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->id }}
                            </td>
                            <td>
                                @if($employeeFamilyDetail->employeeInfo)
                                    <span class="badge badge-relationship">{{ $employeeFamilyDetail->employeeInfo->first_name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->relation_label }}
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->name }}
                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $employeeFamilyDetail->is_dependent ? 'checked' : '' }}>
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->profession }}
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->office_name_address }}
                            </td>
                            <td>
                                {{ $employeeFamilyDetail->office_contact }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('employee_family_detail_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.employee-family-details.show', $employeeFamilyDetail) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('employee_family_detail_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.employee-family-details.edit', $employeeFamilyDetail) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('employee_family_detail_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $employeeFamilyDetail->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $employeeFamilyDetails->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush