<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('employee_attendance_log_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="EmployeeAttendanceLog" format="csv" />
                <livewire:excel-export model="EmployeeAttendanceLog" format="xlsx" />
                <livewire:excel-export model="EmployeeAttendanceLog" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.employeeAttendanceLog.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.date') }}
                            @include('components.table.sort', ['field' => 'date'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.user') }}
                            @include('components.table.sort', ['field' => 'user.name'])
                        </th>
                        <th>
                            {{ trans('cruds.user.fields.email') }}
                            @include('components.table.sort', ['field' => 'user.email'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.type') }}
                            @include('components.table.sort', ['field' => 'type'])
                        </th> --}}
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.coord_lat') }}
                            @include('components.table.sort', ['field' => 'coord_lat'])
                        </th> --}}
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.coord_long') }}
                            @include('components.table.sort', ['field' => 'coord_long'])
                        </th> --}}
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.coord_accu') }}
                            @include('components.table.sort', ['field' => 'coord_accu'])
                        </th> --}}
                        <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.location') }}
                            @include('components.table.sort', ['field' => 'location'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.signed_in_at') }}
                            @include('components.table.sort', ['field' => 'signed_in_at'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.signed_out_at') }}
                            @include('components.table.sort', ['field' => 'signed_out_at'])
                        </th> --}}
                        <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.sign_in_photo') }}
                        </th>
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.sign_out_photo') }}
                        </th> --}}
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.device') }}
                            @include('components.table.sort', ['field' => 'device'])
                        </th> --}}
                        {{-- <th>
                            {{ trans('cruds.employeeAttendanceLog.fields.attendance_from') }}
                            @include('components.table.sort', ['field' => 'attendance_from'])
                        </th> --}}
                        <th>
                            {{-- {{ trans('cruds.employeeAttendanceLog.fields.task') }} --}}
                            Against Ticket
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employeeAttendanceLogs as $employeeAttendanceLog)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $employeeAttendanceLog->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $employeeAttendanceLog->id }}
                            </td>
                            <td>
                                {{ $employeeAttendanceLog->date }}
                            </td>
                            <td>
                                @if($employeeAttendanceLog->user)
                                    <span class="badge badge-relationship">{{ $employeeAttendanceLog->user->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($employeeAttendanceLog->user)
                                    <a class="link-light-blue" href="mailto:{{ $employeeAttendanceLog->user->email ?? '' }}">
                                        <i class="far fa-envelope fa-fw">
                                        </i>
                                        {{ $employeeAttendanceLog->user->email ?? '' }}
                                    </a>
                                @endif
                            </td>
                            {{-- <td>
                                {{ $employeeAttendanceLog->type_label }}
                            </td> --}}
                            {{-- <td>
                                {{ $employeeAttendanceLog->coord_lat }}
                            </td> --}}
                            {{-- <td>
                                {{ $employeeAttendanceLog->coord_long }}
                            </td> --}}
                            {{-- <td>
                                {{ $employeeAttendanceLog->coord_accu }}
                            </td> --}}
                            <td>
                                <div class="grid grid-cols-2 gap-1">
                                    <div class="text-sm font-black">Location Text</div>
                                    <div class="text-xs">{{ $employeeAttendanceLog->location }}</div>
                                    {{--  --}}
                                    <div class="text-sm font-black">Lat:</div>
                                    <div class="text-xs">{{ $employeeAttendanceLog->coord_lat }}</div>
                                    {{--  --}}
                                    <div class="text-sm font-black">Long:</div>
                                    <div class="text-xs">{{ $employeeAttendanceLog->coord_long }}</div>
                                    {{--  --}}
                                    <div class="text-sm font-black"></div>
                                    <div class="text-xs">{{ $employeeAttendanceLog->coord_accu }}</div>
                                    {{--  --}}
                                </div>
                            </td>
                            <td>
                                {{ $employeeAttendanceLog->signed_in_at }}
                            </td>
                            {{-- <td>
                                {{ $employeeAttendanceLog->signed_out_at }}
                            </td> --}}
                            <td>
                                @foreach($employeeAttendanceLog->sign_in_photo as $key => $entry)
                                    <a class="link-photo" href="{{ $entry['url'] }}">
                                        <img src="{{ $entry['thumbnail'] }}" alt="{{ $entry['name'] }}" title="{{ $entry['name'] }}">
                                    </a>
                                @endforeach
                            </td>
                            {{-- <td>
                                @foreach($employeeAttendanceLog->sign_out_photo as $key => $entry)
                                    <a class="link-photo" href="{{ $entry['url'] }}">
                                        <img src="{{ $entry['thumbnail'] }}" alt="{{ $entry['name'] }}" title="{{ $entry['name'] }}">
                                    </a>
                                @endforeach
                            </td> --}}
                            {{-- <td>
                                {{ $employeeAttendanceLog->device }}
                            </td> --}}
                            {{-- <td>
                                {{ $employeeAttendanceLog->attendance_from_label }}
                            </td> --}}
                            <td>
                                @foreach($employeeAttendanceLog->task as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.employee-attendance-logs.show', $employeeAttendanceLog) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                    @can('employee_attendance_log_show')
                                    @endcan
                                    {{-- @can('employee_attendance_log_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.employee-attendance-logs.edit', $employeeAttendanceLog) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan --}}
                                    @can('employee_attendance_log_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $employeeAttendanceLog->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $employeeAttendanceLogs->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
