<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')



    <div class="form-group {{ $errors->has('task.client_group_id') ? 'invalid' : '' }}">
        <label class="form-label" for="client_group">{{ trans('cruds.task.fields.client_group') }}</label>
        <x-select-list class="form-control" id="client_group" name="client_group" :options="$this->listsForFields['client_group']"
            wire:model="task.client_group_id" />
        <div class="validation-message">
            {{ $errors->first('task.client_group_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.client_group_helper') }}
        </div>
    </div>
    {{-- @if ($task->client_group_id) --}}
        {{-- <pre>@json($listsForFields['client'])</pre> --}}
        <div class="form-group {{ $errors->has('task.client_id') ? 'invalid' : '' }}">
            <label class="form-label" for="client">{{ trans('cruds.task.fields.client') }}</label>
            <x-select-list class="form-control" id="client" name="client" :options="$this->listsForFields['client']"
                wire:model="task.client_id" xidp="{{ uniqid() }}" />
            <div class="validation-message">
                {{ $errors->first('task.client_id') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.task.fields.client_helper') }}
            </div>
        </div>
    {{-- @endif --}}
    {{-- @if ($task->client_id) --}}
        <div class="form-group {{ $errors->has('task.client_branch_id') ? 'invalid' : '' }}">
            <label class="form-label" for="client_branch">{{ trans('cruds.task.fields.client_branch') }}</label>
            <x-select-list class="form-control" id="client_branch" name="client_branch" :options="$this->listsForFields['client_branch']"
                wire:model="task.client_branch_id" />
            <div class="validation-message">
                {{ $errors->first('task.client_branch_id') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.task.fields.client_branch_helper') }}
            </div>
        </div>
    {{-- @endif --}}

    <div class="form-group {{ $errors->has('task.name') ? 'invalid' : '' }}">
        <label class="form-label required" for="name">{{ trans('cruds.task.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" required wire:model.defer="task.name">
        <div class="validation-message">
            {{ $errors->first('task.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.task.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="task.description" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('task.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.status_id') ? 'invalid' : '' }} hidden">
        <label class="form-label required" for="status">{{ trans('cruds.task.fields.status') }}</label>
        <x-select-list class="form-control" not-required id="status" name="status" :options="$this->listsForFields['status']"
            wire:model="task.status_id" />
        <div class="validation-message">
            {{ $errors->first('task.status_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.status_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('tag') ? 'invalid' : '' }} hidden">
        <label class="form-label" for="tag">{{ trans('cruds.task.fields.tag') }}</label>
        <x-select-list class="form-control" id="tag" name="tag" wire:model="tag" :options="$this->listsForFields['tag']" multiple />
        <div class="validation-message">
            {{ $errors->first('tag') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.tag_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('mediaCollections.task_attachment') ? 'invalid' : '' }} hidden">
        <label class="form-label" for="attachment">{{ trans('cruds.task.fields.attachment') }}</label>
        <x-dropzone id="attachment" name="attachment" action="{{ route('admin.tasks.storeMedia') }}"
            collection-name="task_attachment" max-file-size="2" max-files="1" />
        <div class="validation-message">
            {{ $errors->first('mediaCollections.task_attachment') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.attachment_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.due_date') ? 'invalid' : '' }} hidden">
        <label class="form-label" for="due_date">{{ trans('cruds.task.fields.due_date') }}</label>
        <x-date-picker class="form-control" wire:model="task.due_date" id="due_date" name="due_date" picker="date" />
        <div class="validation-message">
            {{ $errors->first('task.due_date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.due_date_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.assigned_to_id') ? 'invalid' : '' }} hidden">
        <label class="form-label" for="assigned_to">{{ trans('cruds.task.fields.assigned_to') }}</label>
        <x-select-list class="form-control" id="assigned_to" name="assigned_to" :options="$this->listsForFields['assigned_to']"
            wire:model="task.assigned_to_id" />
        <div class="validation-message">
            {{ $errors->first('task.assigned_to_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.assigned_to_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.call_type') ? 'invalid' : '' }} hidden">
        <label class="form-label">{{ trans('cruds.task.fields.call_type') }}</label>
        @foreach ($this->listsForFields['call_type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="call_type" wire:model="task.call_type"
                    value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('task.call_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.call_type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task.incode') ? 'invalid' : '' }} hidden">
        <label class="form-label" for="incode">{{ trans('cruds.task.fields.incode') }}</label>
        <input class="form-control" type="text" name="incode" id="incode" wire:model.defer="task.incode">
        <div class="validation-message">
            {{ $errors->first('task.incode') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.task.fields.incode_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.tasks.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
