<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('client_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="Client" format="csv" />
                <livewire:excel-export model="Client" format="xlsx" />
                <livewire:excel-export model="Client" format="pdf" />
            @endif


            @can('client_create')
                <x-csv-import route="{{ route('admin.clients.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>

    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.client.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.client_group') }}
                            @include('components.table.sort', ['field' => 'client_group.business_name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.name') }}
                            @include('components.table.sort', ['field' => 'client_group.name'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.state') }}
                            @include('components.table.sort', ['field' => 'state.name'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.rhq_address') }}
                            @include('components.table.sort', ['field' => 'rhq_address'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.rhq_phone') }}
                            @include('components.table.sort', ['field' => 'rhq_phone'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.rhq_email') }}
                            @include('components.table.sort', ['field' => 'rhq_email'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.gstin') }}
                            @include('components.table.sort', ['field' => 'gstin'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.gst_reg_type') }}
                            @include('components.table.sort', ['field' => 'gst_reg_type'])
                        </th>
                        <th>
                            {{ trans('cruds.client.fields.is_active') }}
                            @include('components.table.sort', ['field' => 'is_active'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($clients as $client)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $client->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $client->id }}
                            </td>
                            <td>
                                @if($client->clientGroup)
                                    <span class="badge badge-relationship">{{ $client->clientGroup->business_name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($client->clientGroup)
                                    {{ $client->clientGroup->name ?? '' }}
                                @endif
                            </td>
                            <td>
                                @if($client->state)
                                    <span class="badge badge-relationship">{{ $client->state->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $client->name }}
                            </td>
                            <td>
                                {{ $client->rhq_address }}
                            </td>
                            <td>
                                {{ $client->rhq_phone }}
                            </td>
                            <td>
                                {{ $client->rhq_email }}
                            </td>
                            <td>
                                {{ $client->gstin }}
                            </td>
                            <td>
                                {{ $client->gst_reg_type_label }}
                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $client->is_active ? 'checked' : '' }}>
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('client_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.clients.show', $client) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('client_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.clients.edit', $client) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('client_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $client->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $clients->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
