<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('clientGroup.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.clientGroup.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="clientGroup.name">
        <div class="validation-message">
            {{ $errors->first('clientGroup.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.business_name') ? 'invalid' : '' }}">
        <label class="form-label" for="business_name">{{ trans('cruds.clientGroup.fields.business_name') }}</label>
        <input class="form-control" type="text" name="business_name" id="business_name" wire:model.defer="clientGroup.business_name">
        <div class="validation-message">
            {{ $errors->first('clientGroup.business_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.business_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.address') ? 'invalid' : '' }}">
        <label class="form-label" for="address">{{ trans('cruds.clientGroup.fields.address') }}</label>
        <textarea class="form-control" name="address" id="address" wire:model.defer="clientGroup.address" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('clientGroup.address') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.address_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.phone_1') ? 'invalid' : '' }}">
        <label class="form-label" for="phone_1">{{ trans('cruds.clientGroup.fields.phone_1') }}</label>
        <input class="form-control" type="text" name="phone_1" id="phone_1" wire:model.defer="clientGroup.phone_1">
        <div class="validation-message">
            {{ $errors->first('clientGroup.phone_1') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.phone_1_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.phone_2') ? 'invalid' : '' }}">
        <label class="form-label" for="phone_2">{{ trans('cruds.clientGroup.fields.phone_2') }}</label>
        <input class="form-control" type="text" name="phone_2" id="phone_2" wire:model.defer="clientGroup.phone_2">
        <div class="validation-message">
            {{ $errors->first('clientGroup.phone_2') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.phone_2_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.email_1') ? 'invalid' : '' }}">
        <label class="form-label" for="email_1">{{ trans('cruds.clientGroup.fields.email_1') }}</label>
        <input class="form-control" type="text" name="email_1" id="email_1" wire:model.defer="clientGroup.email_1">
        <div class="validation-message">
            {{ $errors->first('clientGroup.email_1') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.email_1_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.email_2') ? 'invalid' : '' }}">
        <label class="form-label" for="email_2">{{ trans('cruds.clientGroup.fields.email_2') }}</label>
        <input class="form-control" type="text" name="email_2" id="email_2" wire:model.defer="clientGroup.email_2">
        <div class="validation-message">
            {{ $errors->first('clientGroup.email_2') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.email_2_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="clientGroup.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.clientGroup.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('clientGroup.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.is_active_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.has_multi_state_business') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="has_multi_state_business" id="has_multi_state_business" wire:model.defer="clientGroup.has_multi_state_business">
        <label class="form-label inline ml-1" for="has_multi_state_business">{{ trans('cruds.clientGroup.fields.has_multi_state_business') }}</label>
        <div class="validation-message">
            {{ $errors->first('clientGroup.has_multi_state_business') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.has_multi_state_business_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('zone') ? 'invalid' : '' }}">
        <label class="form-label" for="zone">{{ trans('cruds.clientGroup.fields.zone') }}</label>
        <x-select-list class="form-control" id="zone" name="zone" wire:model="zone" :options="$this->listsForFields['zone']" multiple />
        <div class="validation-message">
            {{ $errors->first('zone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.zone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('state') ? 'invalid' : '' }}">
        <label class="form-label" for="state">{{ trans('cruds.clientGroup.fields.state') }}</label>
        <x-select-list class="form-control" id="state" name="state" wire:model="state" :options="$this->listsForFields['state']" multiple />
        <div class="validation-message">
            {{ $errors->first('state') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.state_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circle') ? 'invalid' : '' }}">
        <label class="form-label" for="circle">{{ trans('cruds.clientGroup.fields.circle') }}</label>
        <x-select-list class="form-control" id="circle" name="circle" wire:model="circle" :options="$this->listsForFields['circle']" multiple />
        <div class="validation-message">
            {{ $errors->first('circle') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.circle_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientGroup.operation_manager_id') ? 'invalid' : '' }}">
        <label class="form-label" for="operation_manager">{{ trans('cruds.clientGroup.fields.operation_manager') }}</label>
        <x-select-list class="form-control" id="operation_manager" name="operation_manager" :options="$this->listsForFields['operation_manager']" wire:model="clientGroup.operation_manager_id" />
        <div class="validation-message">
            {{ $errors->first('clientGroup.operation_manager_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientGroup.fields.operation_manager_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.client-groups.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
