<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach ($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('client_branch_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if (file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="ClientBranch" format="csv" />
                <livewire:excel-export model="ClientBranch" format="xlsx" />
                <livewire:excel-export model="ClientBranch" format="pdf" />
            @endif


            @can('client_branch_create')
                <x-csv-import route="{{ route('admin.client-branches.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>

    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.clientBranch.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.address') }}
                            @include('components.table.sort', ['field' => 'address'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.email') }}
                            @include('components.table.sort', ['field' => 'email'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.phone') }}
                            @include('components.table.sort', ['field' => 'phone'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.phone_2') }}
                            @include('components.table.sort', ['field' => 'phone_2'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.circle') }}
                            @include('components.table.sort', ['field' => 'circle.name'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.clientBranch.fields.region') }}
                            @include('components.table.sort', ['field' => 'region.name'])
                        </th> --}}
                        <th>
                            {{ trans('cruds.clientBranch.fields.full_name') }}
                            @include('components.table.sort', ['field' => 'full_name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.latitude') }}
                            @include('components.table.sort', ['field' => 'latitude'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.longitude') }}
                            @include('components.table.sort', ['field' => 'longitude'])
                        </th>
                        <th>
                            {{ trans('cruds.clientBranch.fields.solid_code') }}
                            @include('components.table.sort', ['field' => 'solid_code'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($clientBranches as $clientBranch)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $clientBranch->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $clientBranch->id }}
                            </td>
                            <td>
                                {{ $clientBranch->name }}
                            </td>
                            <td>
                                {{ $clientBranch->address }}
                            </td>
                            <td>
                                {{ $clientBranch->email }}
                            </td>
                            <td>
                                {{ $clientBranch->phone }}
                            </td>
                            <td>
                                {{ $clientBranch->phone_2 }}
                            </td>
                            <td>
                                @if ($clientBranch->circle)
                                    <span
                                        class="badge badge-relationship">{{ $clientBranch->circle->name ?? '' }}</span>
                                @endif
                            </td>
                            {{-- <td>
                                @if ($clientBranch->region)
                                    <span
                                        class="badge badge-relationship">{{ $clientBranch->region->name ?? '' }}</span>
                                @endif
                            </td> --}}
                            <td>
                                {{ $clientBranch->full_name }}
                            </td>
                            <td>
                                {{ $clientBranch->latitude }}
                            </td>
                            <td>
                                {{ $clientBranch->longitude }}
                            </td>
                            <td>
                                {{ $clientBranch->solid_code }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('client_branch_show')
                                        <a class="btn btn-sm btn-info mr-2"
                                            href="{{ route('admin.client-branches.show', $clientBranch) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('client_branch_edit')
                                        <a class="btn btn-sm btn-success mr-2"
                                            href="{{ route('admin.client-branches.edit', $clientBranch) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('client_branch_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button"
                                            wire:click="confirm('delete', {{ $clientBranch->id }})"
                                            wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if ($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $clientBranches->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("{{ trans('global.areYouSure') }}")) {
                return
            }
            @this[e.callback](...e.argv)
        })
    </script>
@endpush
