<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.visitReimbursement.title_singular') }}:
                    {{ trans('cruds.visitReimbursement.fields.id') }}
                    {{ $visitReimbursement->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-1">
                    <div>

                        <table class="table table-view">
                            <tbody class="bg-white">
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.id') }}
                                    </th>
                                    <td>
                                        {{ $visitReimbursement->id }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.user') }}
                                    </th>
                                    <td>
                                        @if ($visitReimbursement->user)
                                            <span
                                                class="badge badge-relationship">{{ $visitReimbursement->user->name ?? '' }}</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.task') }}
                                    </th>
                                    <td>
                                        @if ($visitReimbursement->task)
                                            <span
                                                class="badge badge-relationship">{{ $visitReimbursement->task->name ?? '' }}</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.approved_by') }}
                                    </th>
                                    <td>
                                        @if ($visitReimbursement->approvedBy)
                                            <span
                                                class="badge badge-relationship">{{ $visitReimbursement->approvedBy->name ?? '' }}</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.approved_at') }}
                                    </th>
                                    <td>
                                        {{ $visitReimbursement->approved_at }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.amount') }}
                                    </th>
                                    <td>
                                        {{ $visitReimbursement->amount }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.visit') }}
                                    </th>
                                    <td>
                                        @if ($visitReimbursement->visit)
                                            <span
                                                class="badge badge-relationship">{{ $visitReimbursement->visit->date ?? '' }}</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        {{ trans('cruds.visitReimbursement.fields.status') }}
                                    </th>
                                    <td>
                                        {{ $visitReimbursement->status_label }}
                                    </td>
                                </tr>
                            </tbody>

                        </table>
                    </div>
                    <div class="p-1">
                        <table class="table table-bordered w-full table-fixed">
                            <caption>Routes</caption>
                            <thead>
                                <tr>
                                    <th class="!text-center p-1 !bg-gray-300/25">From</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">To</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Transport <br>Mode</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Journe <br>Type</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Distance <br>(in Km)</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Rate</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Amount</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Note</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($visitReimbursement->routes as $route)
                                    <tr>
                                        <td class="capitalize p-1">{{ $route->from }}</td>
                                        <td class="capitalize p-1">{{ $route->to }}</td>
                                        <td class="capitalize p-1">{{ $route->vehicle_type }}</td>
                                        <td class="capitalize p-1">{{ $route->journey_type }}</td>
                                        <td class="capitalize p-1">{{ $route->journey_distance }}</td>
                                        <td class="capitalize p-1">{{ $route->journey_fare }}</td>
                                        <td class="capitalize p-1">{{ $route->route_cost }}</td>
                                        <td class="capitalize p-1">{{ $route->note }}</td>
                                    </tr>
                                @endforeach
                        </table>
                    </div>

                </div>
            </div>
            <div class="form-group">
                @can('visit_reimbursement_edit')
                    <a href="{{ route('admin.visit-reimbursements.edit', $visitReimbursement) }}"
                        class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="javascript:void(0)"
                    onclick="Livewire.emit('openModal','admin.visit-reimbursement.status-change-component',
                            {{ json_encode(['id' => $visitReimbursement->id]) }})"
                    class="btn btn-indigo mr-2">
                    Status Change
                </a>
                <a href="{{ route('admin.visit-reimbursements.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
