<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach ($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('circle_product_pivot_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if (file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="CircleProductPivot" format="csv" />
                <livewire:excel-export model="CircleProductPivot" format="xlsx" />
                <livewire:excel-export model="CircleProductPivot" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        {{-- <th class="w-9">
                        </th> --}}
                        <th class="w-28">
                            ID
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            Invoice No
                            @include('components.table.sort', ['field' => 'invoice_no'])
                        </th>
                        <th>
                            Invoice Date
                            @include('components.table.sort', ['field' => 'date'])
                        </th>
                        <th>
                            Due Date
                            @include('components.table.sort', ['field' => 'due_date'])
                        </th>
                        <th>
                            Client
                            @include('components.table.sort', ['field' => 'client.name'])
                        </th>
                        <th>
                            Total
                            @include('components.table.sort', ['field' => 'total'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                        {{--
                        invoice_no
                        date
                        due_date
                        total
                        clientGroup
                        client
                        --}}
                        <tr>
                            {{-- <td>
                                <input type="checkbox" value="{{ $invoice->id }}" wire:model="selected">
                            </td> --}}
                            <td>
                                {{ $invoice->id }}
                            </td>
                            <td>
                                {{ $invoice->invoice_no }}
                            </td>
                            <td>
                                {{ $invoice->date_f }}
                            </td>
                            <td>
                                {{ $invoice->due_date_f }}
                            </td>
                            <td>
                                @if ($invoice->client)
                                    <span class="badge badge-relationship">{{ $invoice->client->name ?? '' }}</span>
                                @endif
                            </td>
                            {{-- <td>
                                @if ($invoice->circle)
                                    <span class="badge badge-relationship">{{ $invoice->circle->name ?? '' }}</span>
                                @endif
                            </td> --}}
                            <td>
                                {{ number_format_money($invoice->total) }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <a class="btn btn-sm btn-info mr-2"
                                        href="{{ route('admin.invoices.show', $invoice) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                    <a class="btn btn-sm btn-success mr-2"
                                        href="{{ route('admin.invoices.edit', $invoice) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                    <button class="btn btn-sm btn-rose mr-2" type="button"
                                        wire:click="confirm('delete', {{ $invoice->id }})"
                                        wire:loading.attr="disabled">
                                        {{ trans('global.delete') }}
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if ($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $invoices->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("{{ trans('global.areYouSure') }}")) {
                return
            }
            @this[e.callback](...e.argv)
        })
    </script>
@endpush
