<div wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')
    <div class="grid grid-cols-1 gap-2 mb-2 lg:grid-cols-5">

        <div class="form-group {{ $errors->has('client_group_id') ? 'invalid' : '' }}">
            <label class="form-label" for="clientGroup">Client Group</label>
            <x-select-list class="form-control" id="clientGroup" name="clientGroup" :options="$this->listsForFields['clientGroup']"
                wire:model="client_group_id" />
            <div class="validation-message">
                {{ $errors->first('client_group_id') }}
            </div>
            <div class="help-block">
                Select a Client Group
            </div>
        </div>
        <div class="form-group {{ $errors->has('client_id') ? 'invalid' : '' }}">
            <label class="form-label" for="client">Client</label>
            <x-select-list class="form-control" id="client" name="client" :options="$this->listsForFields['client']"
                wire:model="client_id" />
            <div class="validation-message">
                {{ $errors->first('client_id') }}
            </div>
            <div class="help-block">
                Select a Client
            </div>
        </div>
        <div class="form-group {{ $errors->has('invoice_date') ? 'invalid' : '' }}">
            <label class="form-label" for="invoice_date">Invoice Date</label>
            <x-date-picker class="form-control" wire:model="invoice_date" id="invoice_date" picker="date"
                name="invoice_date" />
            <div class="validation-message">
                {{ $errors->first('invoice_date') }}
            </div>
            <div class="help-block">
                Invoice Date
            </div>
        </div>

        <div class="form-group {{ $errors->has('due_date') ? 'invalid' : '' }}">
            <label class="form-label" for="due_date">Due Date</label>
            <x-date-picker class="form-control" wire:model="due_date" id="due_date" picker="date" name="due_date" />
            <div class="validation-message">
                {{ $errors->first('due_date') }}
            </div>
            <div class="help-block">
                Due Date
            </div>
        </div>


        @if (0)
            <div class="form-group">
                <label class="form-label " for="">&nbsp;</label>
                <button class="mt-2 mr-2 btn btn-indigo" type="button" wire:click="loadProducts">
                    Proceed
                </button>
            </div>
        @endif
    </div>
    {{-- @dump($errors) --}}
    {{-- @fjson($deleted_item_ids) --}}
    {{-- <pre>@json($state['stock'])</pre> --}}
    {{-- @fjson($invoiceItems) --}}
    @if ($clientGroup && $client)
        <div class="relative">
            <div class="p-3 text-right">
                @if (false)
                    <button class="mr-2 btn btn-primary" type="button"
                        wire:click="$emit('openModal', 'common.product-search-modal-component')">
                        Select Products
                    </button>
                @endif
                <button class="mr-2 btn btn-primary" type="button"
                    wire:click="$emit('openModal', 'common.service-search-modal-component',{{ json_encode([
                        'clientGroupId' => $clientGroup->id,
                        'clientId' => $client->id,
                    ]) }})">
                    Select Services
                </button>
                <button class="mr-2 btn btn-primary" type="button"
                    wire:click="$emit('openModal', 'common.task-search-for-invoice-modal-component',{{ json_encode([
                        'clientGroupId' => $clientGroup->id,
                        'clientId' => $client->id,
                    ]) }})">
                    Select Tickets
                </button>
            </div>

            <div class="items-center hidden w-full mb-2 x-flex">
                <label for="simple-search" class="sr-only">Search</label>
                <div class="relative w-full">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <input type="text" id="simpleSearchInput"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Search" required>
                </div>
                <button type="button" onclick="simpleSearchInput.value=''"
                    class="p-2.5 ml-2 text-sm font-medium text-white bg-blue-700 rounded-lg border border-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-5 h-5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    <span class="sr-only">Search</span>
                </button>
            </div>
            <div class="mb-3 overflow-x-auto">
                <table class="table w-full table-index">
                    <thead>
                        <tr>
                            <th>SlNo</th>
                            <th>Product Name/Description</th>
                            <th>HSN</th>
                            <th>Taxable Price </th>
                            <th>New Price </th>
                            {{-- <th>Price</th> --}}
                            <th>Tax Rate</th>
                            {{-- <th>Rate</th> --}}
                            <th>Qty</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($invoiceItems as $pi => $p)
                            @php
                                $pid = Arr::get($p, 'id');
                                $itemSlNo = $loop->iteration;
                                $nameKey = 'invoiceItems.' . $pi . '.name';
                                $descriptionKey = 'invoiceItems.' . $pi . '.description';
                                $hsnCodeKey = 'invoiceItems.' . $pi . '.hsn_code';
                                $isTask = Arr::get($p, 'type') == 'task';
                            @endphp
                            <tr class="" id="{{ uniqid() }}">
                                <td>
                                    <code>#{{ $itemSlNo }}</code>
                                </td>
                                <td>
                                    <div x-data="{ name: @entangle($nameKey).defer, description: @entangle($descriptionKey).defer, }">
                                        {{-- <div x-on:blur="content = $event.target.innerHTML" contenteditable="true">{{ $model->text }}</div> --}}
                                        <div class="form-group border border-b {{ $errors->has($nameKey) ? 'invalid' : '' }}">
                                            <div x-on:blur="name = $event.target.innerText" contenteditable="true"
                                                class="contenteditable-div---a ">{{ Arr::get($p, 'name') }}</div>

                                            <div class="text-xs validation-message">
                                                {{ $errors->first($nameKey) }}
                                            </div>
                                        </div>
                                        <div class="form-group {{ $errors->has($descriptionKey) ? 'invalid' : '' }}">
                                            <div class="block border border-b text-2xs contenteditable-div---a"
                                                x-on:blur="description = $event.target.innerText"
                                                contenteditable="true">{{ Arr::get($p, 'description') }}</div>

                                            <div class="text-xs validation-message">
                                                {{ $errors->first($descriptionKey) }}
                                            </div>
                                        </div>
                                    </div>

                                </td>
                                <td>
                                    <div x-data="{ hsn_code: @entangle($hsnCodeKey).defer }">
                                        <div x-on:blur="hsn_code = $event.target.innerText" contenteditable="true"
                                            class="contenteditable-div---a">
                                            {{ Arr::get($p, 'hsn_code') }}
                                        </div>
                                    </div>

                                    {{-- {{ Arr::get($p, 'hsn_code') }} --}}
                                </td>
                                <td>
                                    ₹{{ Arr::get($p, 'price_o') }}
                                </td>
                                <td>
                                    <div
                                        class="form-group {{ $errors->has("invoiceItems.{$pi}.taxable_price") ? 'invalid' : '' }}">
                                        <input type="number" class="w-[100px] text-sm py-1 px-1"
                                            id="wire-input-taxable_price-{{ $pi }}"
                                            wire:model.debounce.600ms="invoiceItems.{{ $pi }}.taxable_price"
                                            @if ($isTask) disabled readonly @endif
                                            step="0.10" />
                                        <div class="text-xs validation-message">
                                            {{ $errors->first("invoiceItems.{$pi}.taxable_price") }}
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div
                                        class="form-group {{ $errors->has("invoiceItems.{$pi}.gst_rate") ? 'invalid' : '' }}">
                                        <input type="number" class="w-[100px] text-sm py-1 px-1"
                                            id="wire-input-gst_rate-{{ $pi }}"
                                            wire:model.debounce.600ms="invoiceItems.{{ $pi }}.gst_rate"
                                            @if ($isTask) disabled readonly @endif
                                            step="0.10" />
                                        <div class="text-xs validation-message">
                                            {{ $errors->first("invoiceItems.{$pi}.gst_rate") }}
                                        </div>
                                    </div>
                                </td>

                                {{-- <td>
                                    ₹{{ Arr::get($p, 'price') }}
                                </td> --}}
                                <td>
                                    <div
                                        class="form-group {{ $errors->has("invoiceItems.{$pi}.quantity") ? 'invalid' : '' }}">
                                        <input type="number" class="w-[60px] text-sm py-1 px-1"
                                            id="wire-input-quantity-{{ $pi }}"
                                            wire:model.debounce.600ms="invoiceItems.{{ $pi }}.quantity"
                                            @if ($isTask) disabled readonly @endif />
                                        <div class="text-xs validation-message">
                                            {{ $errors->first("invoiceItems.{$pi}.quantity") }}
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    ₹{{ Arr::get($p, 'total') }}
                                </td>
                                <td>
                                    <button type="button" wire:click="removeItem({{ $pi }})"
                                        class="btn btn-sm btn-danger">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M6 18L18 6M6 6l12 12" />
                                        </svg>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                        @if (count($invoiceItems) == 0)
                            <tr>
                                <td class="py-2 text-center" colspan="4">
                                    @if (false)
                                        <button
                                            wire:click="$emit('openModal', 'common.product-search-modal-component')">
                                            Add Product
                                        </button>
                                    @endif
                                    <button
                                        wire:click="$emit('openModal', 'common.task-search-for-invoice-modal-component',{{ json_encode([
                                            'clientGroupId' => $clientGroup->id,
                                            'clientId' => $client->id,
                                        ]) }})">
                                        Add Ticket
                                    </button>
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            {{-- @fjson($invoiceItems) --}}

            @if (count($invoiceItems) > 0)
                <div
                    class="sticky inset-x-0 p-4 text-3xl text-right text-white bg-gray-100 shadow-lg bottom-5 drop-shadow-lg">
                    {{-- @fjson($invoice) --}}
                    @if ($isUpdateMode)
                        <button class="mr-2 btn btn-primary" wire:click="updateInvoice" type="button">
                            Update Invoice
                        </button>
                    @else
                        <button class="mr-2 btn btn-indigo" wire:click="createInvoice" type="button">
                            Create Invoice
                        </button>
                    @endif
                </div>
            @endif


            <div class="mb-2">

                <div class="help-block">
                    Additional Options
                </div>
                <div class="grid grid-cols-1 gap-1 lg:grid-cols-5 ">

                    <div class="form-group {{ $errors->has('inv_type') ? 'invalid' : '' }}">
                        <label class="form-label" for="inv_type">Invoice type</label>
                        <x-select-list class="form-control" id="inv_type" name="inv_type" :options="$this->listsForFields['inv_types']"
                            wire:model="inv_type" />
                        <div class="validation-message">
                            {{ $errors->first('inv_type') }}
                        </div>
                        <div class="help-block">
                        </div>
                    </div>

                    <div class="form-group {{ $errors->has('extra_inv_data.party_name') ? 'invalid' : '' }}">
                        <label class="form-label" for="extra_inv_data-party_name">Client Name</label>
                        <input type="text" class="form-control" id="extra_inv_data-party_name"
                            name="extra_inv_data-party_name" wire:model="extra_inv_data.party_name" />
                        <div class="validation-message">
                            {{ $errors->first('extra_inv_data.party_name') }}
                        </div>
                        <div class="help-block">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    @endif

    {{-- <div class="form-group {{ $errors->has('productZonePivot.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.productZonePivot.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="productZonePivot.product_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.productZonePivot.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="productZonePivot.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.price') ? 'invalid' : '' }}">
        <label class="form-label" for="price">{{ trans('cruds.productZonePivot.fields.price') }}</label>
        <input class="form-control" type="number" name="price" id="price" wire:model.defer="productZonePivot.price" step="0.01">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.price') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.price_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.last_updated_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="last_updated_by">{{ trans('cruds.productZonePivot.fields.last_updated_by') }}</label>
        <x-select-list class="form-control" id="last_updated_by" name="last_updated_by" :options="$this->listsForFields['last_updated_by']" wire:model="productZonePivot.last_updated_by_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.last_updated_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.last_updated_by_helper') }}
        </div>
    </div>
     --}}
    {{--
    <div class="form-group">
        <button class="mr-2 btn btn-indigo" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.product-clientGroup-pivots.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div> --}}
</div>

@push('scripts')
    <script>
        $.ready(function() {
            $(document).on('input', "#simpleSearchInput", function() {
                var value = $(this).val().toLowerCase();
                console.log("value", value)
                $("#simpleSearchTable tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            })
        })
    </script>
@endpush
