<div>
    @php
        // $groupId = $attributes['id'];
        $multiple = $attributes->has('multiple');
        $inputAttributes = $attributes->whereStartsWith(['wire:model']);
        $wireModelAttr = $attributes->whereStartsWith(['wire:model']);
    @endphp
    <div class="w-full" tags-list-group="{{ $groupId }}">
        @if (isset($attributes['multiple']))
            <div id="{{ $attributes['id'] }}-btn-container" class="mb-3">
                <button type="button"
                    class="btn btn-info btn-xs text-2xs select-all-button">{{ trans('global.select_all') }}</button>
                <button type="button"
                    class="btn btn-info btn-xs text-2xs deselect-all-button">{{ trans('global.deselect_all') }}</button>
            </div>
        @endif
        <ul class="x-grid w-full gap-2 x-md:grid-cols-6">

            @foreach ($options as $key => $value)
                {{-- <option value="{{ $key }}">{{ $value }}</option> --}}

                <span class="text-xs inline-flex items-center font-bold leading-sm  px-1 py-1 rounded-full">
                    <input type="{{ $multiple ? 'checkbox' : 'radio' }}" id="{{ $groupId }}-{{ $key }}"
                        name="{{ $attributes['id'] }}" value="{{ $key }}" class="hidden peer"
                        {{ $inputAttributes }}>
                    <label for="{{ $groupId }}-{{ $key }}"
                        class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            {{-- <div class="w-full text-lg font-semibold">0-50 MB</div> --}}
                            <div class="w-full">{{ $value }}</div>
                        </div>
                        {{-- <svg aria-hidden="true" class="w-6 h-6 ml-3" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg> --}}
                    </label>
                </span>
            @endforeach
        </ul>
        {{-- @dump($attributes) --}}
        {{-- <select class="select2 form-control" data-placeholder="{{ __('Select your option') }}" {{ $attributes }}>
            @if (!isset($attributes['multiple']))
                <option></option>
            @endif
            @foreach ($options as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select> --}}
        <div class="select2_container_main" id="{{ $attributes['id'] }}-select2-container-main" wire:ignore>

        </div>
    </div>
</div>

@push('scripts')
    <script>
        // window.lwSelect2 = window.lwSelect2 ?? {};

        document.addEventListener("livewire:load", () => {
            // let el = $('#{{ $attributes['id'] }}')
            let els = $('[tags-list-group="{{ $groupId }}"] :radio,:checkbox');
            let buttonsId = '#{{ $attributes['id'] }}-btn-container'
            let container = $('#{{ $attributes['id'] }}-select2-container-main')
            // lwSelect2['{{ $attributes['id'] }}'] = el;

            function initButtons() {
                $(buttonsId + ' .select-all-button').click(function(e) {
                    els.prop('checked', true);
                    @foreach ( $wireModelAttr as $attrName => $attrValue)
                        @this.set('{{  $attrValue }}', els.get().map(v => v.value));
                    @endforeach

                })

                $(buttonsId + ' .deselect-all-button').click(function(e) {
                    els.prop('checked', false);
                    @foreach ( $wireModelAttr as $attrName => $attrValue)
                        @this.set('{{  $attrValue }}', []);
                    @endforeach
                })
            }

            initButtons();
            // els.on('change', function(e) {
            //     let data = $(this).select2("val")
            //     if (data === "") {
            //         data = null
            //     }
            //     @this.set('{{ $attributes['wire:model'] }}', data)
            // });
        });
    </script>
@endpush
